import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {AvailableStatusMaster, AvailableStatusMasterRelations} from '../models';

export class AvailableStatusMasterRepository extends DefaultCrudRepository<
  AvailableStatusMaster,
  typeof AvailableStatusMaster.prototype.availablestatusId,
  AvailableStatusMasterRelations
> {
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
  ) {
    super(AvailableStatusMaster, dataSource);
  }
}
