import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {AreaMeasurementMaster, AreaMeasurementMasterRelations} from '../models';

export class AreaMeasurementMasterRepository extends DefaultCrudRepository<
  AreaMeasurementMaster,
  typeof AreaMeasurementMaster.prototype.areaMeasurementId,
  AreaMeasurementMasterRelations
> {
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
  ) {
    super(AreaMeasurementMaster, dataSource);
  }
}
