import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {AmenitiesMaster, AmenitiesMasterRelations} from '../models';

export class AmenitiesMasterRepository extends DefaultCrudRepository<
  AmenitiesMaster,
  typeof AmenitiesMaster.prototype.amenitiesId,
  AmenitiesMasterRelations
> {
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
  ) {
    super(AmenitiesMaster, dataSource);
  }
}
