// import {inject} from '@loopback/core';
// import {DefaultCrudRepository} from '@loopback/repository';
// import {DblelloDataSource} from '../datasources';
// import {AdsTypeMaster, AdsTypeMasterRelations} from '../models';

// export class AdsTypeMasterRepository extends DefaultCrudRepository<
//   AdsTypeMaster,
//   typeof AdsTypeMaster.prototype.adsTypeId,
//   AdsTypeMasterRelations
// > {
//   constructor(
//     @inject('datasources.dblello') dataSource: DblelloDataSource,
//   ) {
//     super(AdsTypeMaster, dataSource);
//   }
// }

import {DefaultCrudRepository, repository, HasManyRepositoryFactory} from '@loopback/repository';
import {AdsTypeMaster, AdsManagement} from '../models';
import {DblelloDataSource} from '../datasources';
import {inject, Getter} from '@loopback/core';
import {AdsManagementRepository} from './ads-management.repository';

export class AdsTypeMasterRepository extends DefaultCrudRepository<
  AdsTypeMaster,
  typeof AdsTypeMaster.prototype.adsTypeId
> {
  public readonly adsManagements: HasManyRepositoryFactory<AdsManagement, typeof AdsTypeMaster.prototype.adsTypeId>;

  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
    @repository.getter('AdsManagementRepository')
    protected adsManagementRepositoryGetter: Getter<AdsManagementRepository>,
  ) {
    super(AdsTypeMaster, dataSource);

    this.adsManagements = this.createHasManyRepositoryFactoryFor('adsManagements', adsManagementRepositoryGetter);
    this.registerInclusionResolver('adsManagements', this.adsManagements.inclusionResolver);
  }
}

