import {belongsTo, Entity, model, property} from '@loopback/repository';
import {BuyerMaster} from './buyer-master.model';
import {PostPropertyMaster} from './post-property-master.model';
import {SellerMaster} from './seller-master.model';
import {Usertype} from './usertype.model';

@model({
  settings: {idInjection: false, mysql: {schema: 'lelloproperty', table: 'add_to_cart'}}
})
export class AddToCart extends Entity {
  @property({
    type: 'number',
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 0,
    generated: 1,
    id: 1,
    mysql: {columnName: 'add_tocartId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: 1},
  })
  addTocartId?: number;

  // Polymorphic relation field - this can be either buyerId or sellerId
  @property({
    type: 'number',
    required: true,
    jsonSchema: {nullable: false},
    precision: 10,
    scale: 0,
    generated: false,
    mysql: {columnName: 'fk_buyerId_sellerId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false},
  })
  fkBuyerIdSellerId: number;

  @belongsTo(() => PostPropertyMaster, {name: 'postProperty'}, {
    mysql: {
      columnName: 'fk_postpropertyId',
      dataType: 'int',
      dataPrecision: 10,
      nullable: 'N',
      generated: false,
    }
  })
  fkPostpropertyId: number;

  // BelongsTo relation for usertype
  @belongsTo(() => Usertype, {name: 'usertype'}, {
    mysql: {
      columnName: 'fk_usertypeId',
      dataType: 'int',
      dataPrecision: 10,
      nullable: 'N',
      generated: false,
    }
  })
  fkUsertypeId: number;

  // Add these belongsTo decorators for the polymorphic relations
  @belongsTo(() => BuyerMaster, {name: 'buyer', keyFrom: 'fkBuyerIdSellerId'}, {
    mysql: {
      columnName: 'fk_buyerId_sellerId',
      dataType: 'int',
      dataPrecision: 10,
      nullable: 'N',
      generated: false,
    }
  })
  buyerId?: number;

  @belongsTo(() => SellerMaster, {name: 'seller', keyFrom: 'fkBuyerIdSellerId'}, {
    mysql: {
      columnName: 'fk_buyerId_sellerId',
      dataType: 'int',
      dataPrecision: 10,
      nullable: 'N',
      generated: false,
    }
  })
  sellerId?: number;

  @property({
    type: 'date',
    required: true,
    jsonSchema: {nullable: false},
    generated: false,
    mysql: {columnName: 'Date', dataType: 'date', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'N', generated: false},
  })
  date: string;

  @property({
    type: 'string',
    required: true,
    jsonSchema: {nullable: false},
    generated: false,
    mysql: {columnName: 'Time', dataType: 'time', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'N', generated: false},
  })
  time: string;

  @property({
    type: 'number',
    jsonSchema: {nullable: true},
    precision: 3,
    scale: 0,
    generated: false,
    mysql: {columnName: 'is_default', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false},
  })
  isDefault?: number;

  @property({
    type: 'number',
    jsonSchema: {nullable: true},
    precision: 3,
    scale: 0,
    generated: false,
    mysql: {columnName: 'is_on', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false},
  })
  isOn?: number;

  @property({
    type: 'number',
    jsonSchema: {nullable: true},
    precision: 3,
    scale: 0,
    generated: false,
    mysql: {columnName: 'is_active', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false},
  })
  isActive?: number;

  @property({
    type: 'date',
    jsonSchema: {nullable: true},
    generated: false,
    mysql: {columnName: 'created_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false},
  })
  createdDate?: string;

  @property({
    type: 'number',
    jsonSchema: {nullable: true},
    precision: 10,
    scale: 0,
    generated: false,
    mysql: {columnName: 'created_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false},
  })
  createdBy?: number;

  @property({
    type: 'date',
    jsonSchema: {nullable: true},
    generated: false,
    mysql: {columnName: 'modified_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false},
  })
  modifiedDate?: string;

  @property({
    type: 'number',
    jsonSchema: {nullable: true},
    precision: 10,
    scale: 0,
    generated: false,
    mysql: {columnName: 'modified_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false},
  })
  modifiedBy?: number;

  @property({
    type: 'date',
    jsonSchema: {nullable: true},
    generated: false,
    mysql: {columnName: 'deleted_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false},
  })
  deletedDate?: string;

  @property({
    type: 'number',
    jsonSchema: {nullable: true},
    precision: 10,
    scale: 0,
    generated: false,
    mysql: {columnName: 'deleted_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false},
  })
  deletedBy?: number;

  @property({
    type: 'string',
    jsonSchema: {nullable: true},
    length: 200,
    generated: false,
    mysql: {columnName: 'delete_remark', dataType: 'varchar', dataLength: 200, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false},
  })
  deleteRemark?: string;

  @property({
    type: 'date',
    required: true,
    jsonSchema: {nullable: false},
    generated: false,
    mysql: {columnName: 'last_changed', dataType: 'timestamp', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'N', generated: false},
  })
  lastChanged: string;

  constructor(data?: Partial<AddToCart>) {
    super(data);
  }
}

export interface AddToCartRelations {
  usertype?: Usertype;
  buyer?: BuyerMaster;
  seller?: SellerMaster;
  postProperty?: PostPropertyMaster;
}

export type AddToCartWithRelations = AddToCart & AddToCartRelations;
