import {
  Count,
  CountSchema,
  Filter,
  FilterExcludingWhere,
  repository,
  Where,
} from '@loopback/repository';
import {
  post,
  param,
  get,
  getModelSchemaRef,
  patch,
  put,
  del,
  requestBody,
  response,
} from '@loopback/rest';
import {TransactionTypeMaster} from '../models';
import {TransactionTypeMasterRepository} from '../repositories';

export class TransactionTypeMasterController {
  constructor(
    @repository(TransactionTypeMasterRepository)
    public transactionTypeMasterRepository : TransactionTypeMasterRepository,
  ) {}

  @post('/transaction-type-masters')
  @response(200, {
    description: 'TransactionTypeMaster model instance',
    content: {'application/json': {schema: getModelSchemaRef(TransactionTypeMaster)}},
  })
  async create(
    @requestBody({
      content: {
        'application/json': {
          schema: getModelSchemaRef(TransactionTypeMaster, {
            title: 'NewTransactionTypeMaster',
            exclude: ['transactionId'],
          }),
        },
      },
    })
    transactionTypeMaster: Omit<TransactionTypeMaster, 'transactionId'>,
  ): Promise<TransactionTypeMaster> {
    return this.transactionTypeMasterRepository.create(transactionTypeMaster);
  }

  @get('/transaction-type-masters/count')
  @response(200, {
    description: 'TransactionTypeMaster model count',
    content: {'application/json': {schema: CountSchema}},
  })
  async count(
    @param.where(TransactionTypeMaster) where?: Where<TransactionTypeMaster>,
  ): Promise<Count> {
    return this.transactionTypeMasterRepository.count(where);
  }

  @get('/transaction-type-masters')
  @response(200, {
    description: 'Array of TransactionTypeMaster model instances',
    content: {
      'application/json': {
        schema: {
          type: 'array',
          items: getModelSchemaRef(TransactionTypeMaster, {includeRelations: true}),
        },
      },
    },
  })
  async find(
    @param.filter(TransactionTypeMaster) filter?: Filter<TransactionTypeMaster>,
  ): Promise<TransactionTypeMaster[]> {
    return this.transactionTypeMasterRepository.find(filter);
  }

  @patch('/transaction-type-masters')
  @response(200, {
    description: 'TransactionTypeMaster PATCH success count',
    content: {'application/json': {schema: CountSchema}},
  })
  async updateAll(
    @requestBody({
      content: {
        'application/json': {
          schema: getModelSchemaRef(TransactionTypeMaster, {partial: true}),
        },
      },
    })
    transactionTypeMaster: TransactionTypeMaster,
    @param.where(TransactionTypeMaster) where?: Where<TransactionTypeMaster>,
  ): Promise<Count> {
    return this.transactionTypeMasterRepository.updateAll(transactionTypeMaster, where);
  }

  @get('/transaction-type-masters/{id}')
  @response(200, {
    description: 'TransactionTypeMaster model instance',
    content: {
      'application/json': {
        schema: getModelSchemaRef(TransactionTypeMaster, {includeRelations: true}),
      },
    },
  })
  async findById(
    @param.path.number('id') id: number,
    @param.filter(TransactionTypeMaster, {exclude: 'where'}) filter?: FilterExcludingWhere<TransactionTypeMaster>
  ): Promise<TransactionTypeMaster> {
    return this.transactionTypeMasterRepository.findById(id, filter);
  }

  @patch('/transaction-type-masters/{id}')
  @response(204, {
    description: 'TransactionTypeMaster PATCH success',
  })
  async updateById(
    @param.path.number('id') id: number,
    @requestBody({
      content: {
        'application/json': {
          schema: getModelSchemaRef(TransactionTypeMaster, {partial: true}),
        },
      },
    })
    transactionTypeMaster: TransactionTypeMaster,
  ): Promise<void> {
    await this.transactionTypeMasterRepository.updateById(id, transactionTypeMaster);
  }

  @put('/transaction-type-masters/{id}')
  @response(204, {
    description: 'TransactionTypeMaster PUT success',
  })
  async replaceById(
    @param.path.number('id') id: number,
    @requestBody() transactionTypeMaster: TransactionTypeMaster,
  ): Promise<void> {
    await this.transactionTypeMasterRepository.replaceById(id, transactionTypeMaster);
  }

  @del('/transaction-type-masters/{id}')
  @response(204, {
    description: 'TransactionTypeMaster DELETE success',
  })
  async deleteById(@param.path.number('id') id: number): Promise<void> {
    await this.transactionTypeMasterRepository.deleteById(id);
  }
}
