import {
  Count,
  CountSchema,
  Filter,
  FilterExcludingWhere,
  repository,
  Where,
} from '@loopback/repository';
import {
  del,
  get,
  getModelSchemaRef,
  param,
  patch,
  post,
  put,
  requestBody,
  response,
} from '@loopback/rest';
import {PostPropertyAmenities} from '../models';
import {PostPropertyAmenitiesRepository} from '../repositories';

export class PostPropertyAmenitiesController {
  constructor(
    @repository(PostPropertyAmenitiesRepository)
    public postPropertyAmenitiesRepository: PostPropertyAmenitiesRepository,
  ) { }

  @post('/post-property-amenities')
  @response(200, {
    description: 'PostPropertyAmenities model instance',
    content: {'application/json': {schema: getModelSchemaRef(PostPropertyAmenities)}},
  })
  async create(
    @requestBody({
      content: {
        'application/json': {
          schema: getModelSchemaRef(PostPropertyAmenities, {
            title: 'NewPostPropertyAmenities',
            exclude: ['id'],
          }),
        },
      },
    })
    postPropertyAmenities: Omit<PostPropertyAmenities, 'id'>,
  ): Promise<PostPropertyAmenities> {
    return this.postPropertyAmenitiesRepository.create(postPropertyAmenities);
  }

  @get('/post-property-amenities/count')
  @response(200, {
    description: 'PostPropertyAmenities model count',
    content: {'application/json': {schema: CountSchema}},
  })
  async count(
    @param.where(PostPropertyAmenities) where?: Where<PostPropertyAmenities>,
  ): Promise<Count> {
    return this.postPropertyAmenitiesRepository.count(where);
  }

  @get('/post-property-amenities')
  @response(200, {
    description: 'Array of PostPropertyAmenities model instances',
    content: {
      'application/json': {
        schema: {
          type: 'array',
          items: getModelSchemaRef(PostPropertyAmenities, {includeRelations: true}),
        },
      },
    },
  })
  async find(
    @param.filter(PostPropertyAmenities) filter?: Filter<PostPropertyAmenities>,
  ): Promise<PostPropertyAmenities[]> {
    const newFilter = {
      ...filter,
      fields: {
      isDefault: false,
      isOn: false,
      isActive: false,
      createdDate: false,
      createdBy: false,
      modifiedDate: false,
      modifiedBy: false,
      deletedDate: false,
      deletedBy: false,
      deleteRemark: false,
      lastChanged: false,
    },
      include: [
      {
        relation: 'postProperty',
        scope: {
          fields: {
            isDefault: false,
            isOn: false,
            isActive: false,
            createdDate: false,
            createdBy: false,
            modifiedDate: false,
            modifiedBy: false,
            deletedDate: false,
            deletedBy: false,
            deleteRemark: false,
            lastChanged: false,
          }
        }
      },

      {
        relation: 'amenity',
        scope: {
          fields: {
            isDefault: false,
            isOn: false,
            isActive: false,
            createdDate: false,
            createdBy: false,
            modifiedDate: false,
            modifiedBy: false,
            deletedDate: false,
            deletedBy: false,
            deleteRemark: false,
            lastChanged: false,
          }
        }
      }
    ],
    };
    return this.postPropertyAmenitiesRepository.find(newFilter);
  }


  @patch('/post-property-amenities')
  @response(200, {
    description: 'PostPropertyAmenities PATCH success count',
    content: {'application/json': {schema: CountSchema}},
  })
  async updateAll(
    @requestBody({
      content: {
        'application/json': {
          schema: getModelSchemaRef(PostPropertyAmenities, {partial: true}),
        },
      },
    })
    postPropertyAmenities: PostPropertyAmenities,
    @param.where(PostPropertyAmenities) where?: Where<PostPropertyAmenities>,
  ): Promise<Count> {
    return this.postPropertyAmenitiesRepository.updateAll(postPropertyAmenities, where);
  }

  @get('/post-property-amenities/{id}')
  @response(200, {
    description: 'PostPropertyAmenities model instance',
    content: {
      'application/json': {
        schema: getModelSchemaRef(PostPropertyAmenities, {includeRelations: true}),
      },
    },
  })
  async findById(
    @param.path.number('id') id: number,
    @param.filter(PostPropertyAmenities, {exclude: 'where'}) filter?: FilterExcludingWhere<PostPropertyAmenities>
  ): Promise<PostPropertyAmenities> {

    const newFilter = {
      ...filter,
       fields: {
      isDefault: false,
      isOn: false,
      isActive: false,
      createdDate: false,
      createdBy: false,
      modifiedDate: false,
      modifiedBy: false,
      deletedDate: false,
      deletedBy: false,
      deleteRemark: false,
      lastChanged: false,
    },
      include: [
      {
        relation: 'postProperty',
        scope: {
          fields: {
            isDefault: false,
            isOn: false,
            isActive: false,
            createdDate: false,
            createdBy: false,
            modifiedDate: false,
            modifiedBy: false,
            deletedDate: false,
            deletedBy: false,
            deleteRemark: false,
            lastChanged: false,
          }
        }
      },

      {
        relation: 'amenity',
        scope: {
          fields: {
            isDefault: false,
            isOn: false,
            isActive: false,
            createdDate: false,
            createdBy: false,
            modifiedDate: false,
            modifiedBy: false,
            deletedDate: false,
            deletedBy: false,
            deleteRemark: false,
            lastChanged: false,
          }
        }
      }
    ],
    };

    return this.postPropertyAmenitiesRepository.findById(id, newFilter);
  }


  @patch('/post-property-amenities/{id}')
  @response(204, {
    description: 'PostPropertyAmenities PATCH success',
  })
  async updateById(
    @param.path.number('id') id: number,
    @requestBody({
      content: {
        'application/json': {
          schema: getModelSchemaRef(PostPropertyAmenities, {partial: true}),
        },
      },
    })
    postPropertyAmenities: PostPropertyAmenities,
  ): Promise<void> {
    await this.postPropertyAmenitiesRepository.updateById(id, postPropertyAmenities);
  }

  @put('/post-property-amenities/{id}')
  @response(204, {
    description: 'PostPropertyAmenities PUT success',
  })
  async replaceById(
    @param.path.number('id') id: number,
    @requestBody() postPropertyAmenities: PostPropertyAmenities,
  ): Promise<void> {
    await this.postPropertyAmenitiesRepository.replaceById(id, postPropertyAmenities);
  }

  @del('/post-property-amenities/{id}')
  @response(204, {
    description: 'PostPropertyAmenities DELETE success',
  })
  async deleteById(@param.path.number('id') id: number): Promise<void> {
    await this.postPropertyAmenitiesRepository.deleteById(id);
  }
}
