import {
  Count,
  CountSchema,
  Filter,
  FilterExcludingWhere,
  repository,
  Where,
} from '@loopback/repository';
import {
  post,
  param,
  get,
  getModelSchemaRef,
  patch,
  put,
  del,
  requestBody,
  response,
} from '@loopback/rest';
import {FacingMaster} from '../models';
import {FacingMasterRepository} from '../repositories';

export class FacingMasterController {
  constructor(
    @repository(FacingMasterRepository)
    public facingMasterRepository : FacingMasterRepository,
  ) {}

  @post('/facing-masters')
  @response(200, {
    description: 'FacingMaster model instance',
    content: {'application/json': {schema: getModelSchemaRef(FacingMaster)}},
  })
  async create(
    @requestBody({
      content: {
        'application/json': {
          schema: getModelSchemaRef(FacingMaster, {
            title: 'NewFacingMaster',
            exclude: ['facingId'],
          }),
        },
      },
    })
    facingMaster: Omit<FacingMaster, 'facingId'>,
  ): Promise<FacingMaster> {
    return this.facingMasterRepository.create(facingMaster);
  }

  @get('/facing-masters/count')
  @response(200, {
    description: 'FacingMaster model count',
    content: {'application/json': {schema: CountSchema}},
  })
  async count(
    @param.where(FacingMaster) where?: Where<FacingMaster>,
  ): Promise<Count> {
    return this.facingMasterRepository.count(where);
  }

  @get('/facing-masters')
  @response(200, {
    description: 'Array of FacingMaster model instances',
    content: {
      'application/json': {
        schema: {
          type: 'array',
          items: getModelSchemaRef(FacingMaster, {includeRelations: true}),
        },
      },
    },
  })
  async find(
    @param.filter(FacingMaster) filter?: Filter<FacingMaster>,
  ): Promise<FacingMaster[]> {
    return this.facingMasterRepository.find(filter);
  }

  @patch('/facing-masters')
  @response(200, {
    description: 'FacingMaster PATCH success count',
    content: {'application/json': {schema: CountSchema}},
  })
  async updateAll(
    @requestBody({
      content: {
        'application/json': {
          schema: getModelSchemaRef(FacingMaster, {partial: true}),
        },
      },
    })
    facingMaster: FacingMaster,
    @param.where(FacingMaster) where?: Where<FacingMaster>,
  ): Promise<Count> {
    return this.facingMasterRepository.updateAll(facingMaster, where);
  }

  @get('/facing-masters/{id}')
  @response(200, {
    description: 'FacingMaster model instance',
    content: {
      'application/json': {
        schema: getModelSchemaRef(FacingMaster, {includeRelations: true}),
      },
    },
  })
  async findById(
    @param.path.number('id') id: number,
    @param.filter(FacingMaster, {exclude: 'where'}) filter?: FilterExcludingWhere<FacingMaster>
  ): Promise<FacingMaster> {
    return this.facingMasterRepository.findById(id, filter);
  }

  @patch('/facing-masters/{id}')
  @response(204, {
    description: 'FacingMaster PATCH success',
  })
  async updateById(
    @param.path.number('id') id: number,
    @requestBody({
      content: {
        'application/json': {
          schema: getModelSchemaRef(FacingMaster, {partial: true}),
        },
      },
    })
    facingMaster: FacingMaster,
  ): Promise<void> {
    await this.facingMasterRepository.updateById(id, facingMaster);
  }

  @put('/facing-masters/{id}')
  @response(204, {
    description: 'FacingMaster PUT success',
  })
  async replaceById(
    @param.path.number('id') id: number,
    @requestBody() facingMaster: FacingMaster,
  ): Promise<void> {
    await this.facingMasterRepository.replaceById(id, facingMaster);
  }

  @del('/facing-masters/{id}')
  @response(204, {
    description: 'FacingMaster DELETE success',
  })
  async deleteById(@param.path.number('id') id: number): Promise<void> {
    await this.facingMasterRepository.deleteById(id);
  }
}
