"use strict";
// import {inject} from '@loopback/core';
// import {DefaultCrudRepository} from '@loopback/repository';
// import {DblelloDataSource} from '../datasources';
// import {SellerMaster, SellerMasterRelations} from '../models';
Object.defineProperty(exports, "__esModule", { value: true });
exports.SellerMasterRepository = void 0;
const tslib_1 = require("tslib");
// export class SellerMasterRepository extends DefaultCrudRepository<
//   SellerMaster,
//   typeof SellerMaster.prototype.sellerId,
//   SellerMasterRelations
// > {
//   constructor(
//     @inject('datasources.dblello') dataSource: DblelloDataSource,
//   ) {
//     super(SellerMaster, dataSource);
//   }
// }
const core_1 = require("@loopback/core");
const repository_1 = require("@loopback/repository");
const datasources_1 = require("../datasources");
const models_1 = require("../models");
let SellerMasterRepository = class SellerMasterRepository extends repository_1.DefaultCrudRepository {
    constructor(dataSource, cityRepoGetter, userRepoGetter, genderRepoGetter) {
        super(models_1.SellerMaster, dataSource);
        this.cityRepoGetter = cityRepoGetter;
        this.userRepoGetter = userRepoGetter;
        this.genderRepoGetter = genderRepoGetter;
        this.city = this.createBelongsToAccessorFor('city', cityRepoGetter);
        // this.package = this.createBelongsToAccessorFor('package', packageRepoGetter);
        this.user = this.createBelongsToAccessorFor('user', userRepoGetter);
        this.gender = this.createBelongsToAccessorFor('gender', genderRepoGetter);
        this.registerInclusionResolver('city', this.city.inclusionResolver);
        // this.registerInclusionResolver('package', this.package.inclusionResolver);
        this.registerInclusionResolver('user', this.user.inclusionResolver);
        this.registerInclusionResolver('gender', this.gender.inclusionResolver);
    }
};
exports.SellerMasterRepository = SellerMasterRepository;
exports.SellerMasterRepository = SellerMasterRepository = tslib_1.__decorate([
    tslib_1.__param(0, (0, core_1.inject)('datasources.dblello')),
    tslib_1.__param(1, repository_1.repository.getter('CityMasterRepository')),
    tslib_1.__param(2, repository_1.repository.getter('UsertypeRepository')),
    tslib_1.__param(3, repository_1.repository.getter('GenderMasterRepository')),
    tslib_1.__metadata("design:paramtypes", [datasources_1.DblelloDataSource, Function, Function, Function])
], SellerMasterRepository);
//# sourceMappingURL=seller-master.repository.js.map