import { Getter } from '@loopback/core';
import { BelongsToAccessor, DefaultCrudRepository } from '@loopback/repository';
import { DblelloDataSource } from '../datasources';
import { CityMaster, GenderMaster, SellerMaster, SellerMasterRelations, Usertype } from '../models';
import { CityMasterRepository } from './city-master.repository';
import { GenderMasterRepository } from './gender-master.repository';
import { UsertypeRepository } from './usertype.repository';
export declare class SellerMasterRepository extends DefaultCrudRepository<SellerMaster, typeof SellerMaster.prototype.sellerId, SellerMasterRelations> {
    protected cityRepoGetter: Getter<CityMasterRepository>;
    protected userRepoGetter: Getter<UsertypeRepository>;
    protected genderRepoGetter: Getter<GenderMasterRepository>;
    readonly city: BelongsToAccessor<CityMaster, typeof SellerMaster.prototype.sellerId>;
    readonly user: BelongsToAccessor<Usertype, typeof SellerMaster.prototype.sellerId>;
    readonly gender: BelongsToAccessor<GenderMaster, typeof SellerMaster.prototype.sellerId>;
    constructor(dataSource: DblelloDataSource, cityRepoGetter: Getter<CityMasterRepository>, userRepoGetter: Getter<UsertypeRepository>, genderRepoGetter: Getter<GenderMasterRepository>);
}
