"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostPropertyMasterRepository = void 0;
const tslib_1 = require("tslib");
/* eslint-disable @typescript-eslint/no-unused-vars */
const core_1 = require("@loopback/core");
const repository_1 = require("@loopback/repository");
const datasources_1 = require("../datasources");
const models_1 = require("../models");
let PostPropertyMasterRepository = class PostPropertyMasterRepository extends repository_1.DefaultCrudRepository {
    constructor(dataSource, sellerMasterRepositoryGetter, publishTypeMasterRepositoryGetter, furnishingTypeMasterRepositoryGetter, possessionMasterRepositoryGetter, transactionTypeMasterRepositoryGetter, floorMasterRepositoryGetter, mainPropertyTypeMasterRepositoryGetter, maintenanceMonthMasterRepositoryGetter, otherRoomMasterRepositoryGetter, ownershipMasterRepositoryGetter, userTypeRepositoryGetter, postTypeMasterRepositoryGetter, propertyTypeMasterRepositoryGetter, availableStatusMasterRepositoryGetter, facingMasterRepositoryGetter, amenitiesRepositoryGetter, propertyAmenitiesRepositoryGetter) {
        super(models_1.PostPropertyMaster, dataSource);
        this.sellerMasterRepositoryGetter = sellerMasterRepositoryGetter;
        this.publishTypeMasterRepositoryGetter = publishTypeMasterRepositoryGetter;
        this.furnishingTypeMasterRepositoryGetter = furnishingTypeMasterRepositoryGetter;
        this.possessionMasterRepositoryGetter = possessionMasterRepositoryGetter;
        this.transactionTypeMasterRepositoryGetter = transactionTypeMasterRepositoryGetter;
        this.floorMasterRepositoryGetter = floorMasterRepositoryGetter;
        this.mainPropertyTypeMasterRepositoryGetter = mainPropertyTypeMasterRepositoryGetter;
        this.maintenanceMonthMasterRepositoryGetter = maintenanceMonthMasterRepositoryGetter;
        this.otherRoomMasterRepositoryGetter = otherRoomMasterRepositoryGetter;
        this.ownershipMasterRepositoryGetter = ownershipMasterRepositoryGetter;
        this.userTypeRepositoryGetter = userTypeRepositoryGetter;
        this.postTypeMasterRepositoryGetter = postTypeMasterRepositoryGetter;
        this.propertyTypeMasterRepositoryGetter = propertyTypeMasterRepositoryGetter;
        this.availableStatusMasterRepositoryGetter = availableStatusMasterRepositoryGetter;
        this.facingMasterRepositoryGetter = facingMasterRepositoryGetter;
        this.amenitiesRepositoryGetter = amenitiesRepositoryGetter;
        this.propertyAmenitiesRepositoryGetter = propertyAmenitiesRepositoryGetter;
        this.seller = this.createBelongsToAccessorFor('seller', sellerMasterRepositoryGetter);
        this.registerInclusionResolver('seller', this.seller.inclusionResolver);
        this.publishType = this.createBelongsToAccessorFor('publishType', publishTypeMasterRepositoryGetter);
        this.registerInclusionResolver('publishType', this.publishType.inclusionResolver);
        this.furnishingType = this.createBelongsToAccessorFor('furnishingType', furnishingTypeMasterRepositoryGetter);
        this.registerInclusionResolver('furnishingType', this.furnishingType.inclusionResolver);
        this.possessionType = this.createBelongsToAccessorFor('possessionType', possessionMasterRepositoryGetter);
        this.registerInclusionResolver('possessionType', this.possessionType.inclusionResolver);
        this.transactionType = this.createBelongsToAccessorFor('transactionType', transactionTypeMasterRepositoryGetter);
        this.registerInclusionResolver('transactionType', this.transactionType.inclusionResolver);
        this.floor = this.createBelongsToAccessorFor('floor', floorMasterRepositoryGetter);
        this.registerInclusionResolver('floor', this.floor.inclusionResolver);
        this.mainPropertyType = this.createBelongsToAccessorFor('mainPropertyType', mainPropertyTypeMasterRepositoryGetter);
        this.registerInclusionResolver('mainPropertyType', this.mainPropertyType.inclusionResolver);
        this.maintenanceMonth = this.createBelongsToAccessorFor('maintenanceMonth', maintenanceMonthMasterRepositoryGetter);
        this.registerInclusionResolver('maintenanceMonth', this.maintenanceMonth.inclusionResolver);
        this.otherRoom = this.createBelongsToAccessorFor('otherRoom', otherRoomMasterRepositoryGetter);
        this.registerInclusionResolver('otherRoom', this.otherRoom.inclusionResolver);
        this.ownership = this.createBelongsToAccessorFor('ownership', ownershipMasterRepositoryGetter);
        this.registerInclusionResolver('ownership', this.ownership.inclusionResolver);
        this.userType = this.createBelongsToAccessorFor('userType', userTypeRepositoryGetter);
        this.registerInclusionResolver('userType', this.userType.inclusionResolver);
        this.postType = this.createBelongsToAccessorFor('postType', postTypeMasterRepositoryGetter);
        this.registerInclusionResolver('postType', this.postType.inclusionResolver);
        this.propertyType = this.createBelongsToAccessorFor('propertyType', propertyTypeMasterRepositoryGetter);
        this.registerInclusionResolver('propertyType', this.propertyType.inclusionResolver);
        this.availableStatus = this.createBelongsToAccessorFor('availableStatus', availableStatusMasterRepositoryGetter);
        this.registerInclusionResolver('availableStatus', this.availableStatus.inclusionResolver);
        this.facing = this.createBelongsToAccessorFor('facing', facingMasterRepositoryGetter);
        this.registerInclusionResolver('facing', this.facing.inclusionResolver);
        // this.amenities = this.createBelongsToAccessorFor(
        //   'amenities',
        //   amenitiesRepositoryGetter,
        // );
        // this.registerInclusionResolver('amenities', this.amenities.inclusionResolver);
        this.amenities = this.createHasManyThroughRepositoryFactoryFor('amenities', amenitiesRepositoryGetter, propertyAmenitiesRepositoryGetter);
        this.registerInclusionResolver('amenities', this.amenities.inclusionResolver);
    }
};
exports.PostPropertyMasterRepository = PostPropertyMasterRepository;
exports.PostPropertyMasterRepository = PostPropertyMasterRepository = tslib_1.__decorate([
    tslib_1.__param(0, (0, core_1.inject)('datasources.dblello')),
    tslib_1.__param(1, repository_1.repository.getter('SellerMasterRepository')),
    tslib_1.__param(2, repository_1.repository.getter('PublishTypeMasterRepository')),
    tslib_1.__param(3, repository_1.repository.getter('FurnishingtypeMasterRepository')),
    tslib_1.__param(4, repository_1.repository.getter('PossessionMasterRepository')),
    tslib_1.__param(5, repository_1.repository.getter('TransactionTypeMasterRepository')),
    tslib_1.__param(6, repository_1.repository.getter('FloorMasterRepository')),
    tslib_1.__param(7, repository_1.repository.getter('MainProperttyTypeMasterRepository')),
    tslib_1.__param(8, repository_1.repository.getter('MaintenanceMonthMasterRepository')),
    tslib_1.__param(9, repository_1.repository.getter('OtherRoomMasterRepository')),
    tslib_1.__param(10, repository_1.repository.getter('OwnershipMasterRepository')),
    tslib_1.__param(11, repository_1.repository.getter('UsertypeRepository')),
    tslib_1.__param(12, repository_1.repository.getter('PostTypeMasterRepository')),
    tslib_1.__param(13, repository_1.repository.getter('PropertyTypeMasterRepository')),
    tslib_1.__param(14, repository_1.repository.getter('AvailableStatusMasterRepository')),
    tslib_1.__param(15, repository_1.repository.getter('FacingMasterRepository')),
    tslib_1.__param(16, repository_1.repository.getter('AmenitiesMasterRepository')),
    tslib_1.__param(17, repository_1.repository.getter('PostPropertyAmenitiesRepository')),
    tslib_1.__metadata("design:paramtypes", [datasources_1.DblelloDataSource, Function, Function, Function, Function, Function, Function, Function, Function, Function, Function, Function, Function, Function, Function, Function, Function, Function])
], PostPropertyMasterRepository);
//# sourceMappingURL=post-property-master.repository.js.map