"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostPropertyAmenitiesRepository = void 0;
const tslib_1 = require("tslib");
const core_1 = require("@loopback/core");
const repository_1 = require("@loopback/repository");
const datasources_1 = require("../datasources");
const models_1 = require("../models");
let PostPropertyAmenitiesRepository = class PostPropertyAmenitiesRepository extends repository_1.DefaultCrudRepository {
    constructor(dataSource, postPropertyMasterRepositoryGetter, amenitiesMasterRepositoryGetter) {
        super(models_1.PostPropertyAmenities, dataSource);
        this.postPropertyMasterRepositoryGetter = postPropertyMasterRepositoryGetter;
        this.amenitiesMasterRepositoryGetter = amenitiesMasterRepositoryGetter;
        this.postProperty = this.createBelongsToAccessorFor('postProperty', postPropertyMasterRepositoryGetter);
        this.registerInclusionResolver('postProperty', this.postProperty.inclusionResolver);
        this.amenity = this.createBelongsToAccessorFor('amenity', amenitiesMasterRepositoryGetter);
        this.registerInclusionResolver('amenity', this.amenity.inclusionResolver);
    }
};
exports.PostPropertyAmenitiesRepository = PostPropertyAmenitiesRepository;
exports.PostPropertyAmenitiesRepository = PostPropertyAmenitiesRepository = tslib_1.__decorate([
    tslib_1.__param(0, (0, core_1.inject)('datasources.dblello')),
    tslib_1.__param(1, repository_1.repository.getter('PostPropertyMasterRepository')),
    tslib_1.__param(2, repository_1.repository.getter('AmenitiesMasterRepository')),
    tslib_1.__metadata("design:paramtypes", [datasources_1.DblelloDataSource, Function, Function])
], PostPropertyAmenitiesRepository);
//# sourceMappingURL=post-property-amenities.repository.js.map