"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogBuyerRepository = void 0;
const tslib_1 = require("tslib");
const core_1 = require("@loopback/core");
const repository_1 = require("@loopback/repository");
const datasources_1 = require("../datasources");
const models_1 = require("../models");
let LogBuyerRepository = class LogBuyerRepository extends repository_1.DefaultCrudRepository {
    constructor(dataSource, buyerMasterRepoGetter, postPropertyMasterRepoGetter) {
        super(models_1.LogBuyer, dataSource);
        this.buyerMasterRepoGetter = buyerMasterRepoGetter;
        this.postPropertyMasterRepoGetter = postPropertyMasterRepoGetter;
        // Create BelongsTo accessor for buyer
        this.buyer = this.createBelongsToAccessorFor('buyer', buyerMasterRepoGetter);
        this.registerInclusionResolver('buyer', this.buyer.inclusionResolver);
        // Create BelongsTo accessor for postProperty
        this.postProperty = this.createBelongsToAccessorFor('postProperty', postPropertyMasterRepoGetter);
        this.registerInclusionResolver('postProperty', this.postProperty.inclusionResolver);
    }
};
exports.LogBuyerRepository = LogBuyerRepository;
exports.LogBuyerRepository = LogBuyerRepository = tslib_1.__decorate([
    tslib_1.__param(0, (0, core_1.inject)('datasources.dblello')),
    tslib_1.__param(1, repository_1.repository.getter('BuyerMasterRepository')),
    tslib_1.__param(2, repository_1.repository.getter('PostPropertyMasterRepository')),
    tslib_1.__metadata("design:paramtypes", [datasources_1.DblelloDataSource, Function, Function])
], LogBuyerRepository);
//# sourceMappingURL=log-buyer.repository.js.map