"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GenderMasterRepository = void 0;
const tslib_1 = require("tslib");
const core_1 = require("@loopback/core");
const repository_1 = require("@loopback/repository");
const datasources_1 = require("../datasources");
const models_1 = require("../models");
let GenderMasterRepository = class GenderMasterRepository extends repository_1.DefaultCrudRepository {
    constructor(dataSource, sellerMasterRepositoryGetter, buyerMasterRepositoryGetter) {
        super(models_1.GenderMaster, dataSource);
        this.sellerMasterRepositoryGetter = sellerMasterRepositoryGetter;
        this.buyerMasterRepositoryGetter = buyerMasterRepositoryGetter;
        this.buyers = this.createHasManyRepositoryFactoryFor('buyers', buyerMasterRepositoryGetter);
        this.registerInclusionResolver('buyers', this.buyers.inclusionResolver);
        this.sellers = this.createHasManyRepositoryFactoryFor('sellers', sellerMasterRepositoryGetter);
        this.registerInclusionResolver('sellers', this.sellers.inclusionResolver);
    }
};
exports.GenderMasterRepository = GenderMasterRepository;
exports.GenderMasterRepository = GenderMasterRepository = tslib_1.__decorate([
    tslib_1.__param(0, (0, core_1.inject)('datasources.dblello')),
    tslib_1.__param(1, repository_1.repository.getter('SellerMasterRepository')),
    tslib_1.__param(2, repository_1.repository.getter('BuyerMasterRepository')),
    tslib_1.__metadata("design:paramtypes", [datasources_1.DblelloDataSource, Function, Function])
], GenderMasterRepository);
//# sourceMappingURL=gender-master.repository.js.map