"use strict";
// import {inject} from '@loopback/core';
// import {DefaultCrudRepository} from '@loopback/repository';
// import {DblelloDataSource} from '../datasources';
// import {CityMaster, CityMasterRelations} from '../models';
Object.defineProperty(exports, "__esModule", { value: true });
exports.CityMasterRepository = void 0;
const tslib_1 = require("tslib");
// export class CityMasterRepository extends DefaultCrudRepository<
//   CityMaster,
//   typeof CityMaster.prototype.cityId,
//   CityMasterRelations
// > {
//   constructor(
//     @inject('datasources.dblello') dataSource: DblelloDataSource,
//   ) {
//     super(CityMaster, dataSource);
//   }
// }
const core_1 = require("@loopback/core");
const repository_1 = require("@loopback/repository");
const datasources_1 = require("../datasources");
const models_1 = require("../models");
let CityMasterRepository = class CityMasterRepository extends repository_1.DefaultCrudRepository {
    constructor(dataSource, buyerMasterRepositoryGetter, sellerMasterRepositoryGetter) {
        super(models_1.CityMaster, dataSource);
        this.buyerMasterRepositoryGetter = buyerMasterRepositoryGetter;
        this.sellerMasterRepositoryGetter = sellerMasterRepositoryGetter;
        this.buyers = this.createHasManyRepositoryFactoryFor('buyers', buyerMasterRepositoryGetter);
        this.registerInclusionResolver('buyers', this.buyers.inclusionResolver);
        this.sellers = this.createHasManyRepositoryFactoryFor('sellers', sellerMasterRepositoryGetter); // 👈
        this.registerInclusionResolver('sellers', this.sellers.inclusionResolver);
    }
};
exports.CityMasterRepository = CityMasterRepository;
exports.CityMasterRepository = CityMasterRepository = tslib_1.__decorate([
    tslib_1.__param(0, (0, core_1.inject)('datasources.dblello')),
    tslib_1.__param(1, repository_1.repository.getter('BuyerMasterRepository')),
    tslib_1.__param(2, repository_1.repository.getter('SellerMasterRepository')),
    tslib_1.__metadata("design:paramtypes", [datasources_1.DblelloDataSource, Function, Function])
], CityMasterRepository);
//# sourceMappingURL=city-master.repository.js.map