"use strict";
// import {inject} from '@loopback/core';
// import {DefaultCrudRepository} from '@loopback/repository';
// import {DblelloDataSource} from '../datasources';
// import {BuyerMaster, BuyerMasterRelations} from '../models';
Object.defineProperty(exports, "__esModule", { value: true });
exports.BuyerMasterRepository = void 0;
const tslib_1 = require("tslib");
// export class BuyerMasterRepository extends DefaultCrudRepository<
//   BuyerMaster,
//   typeof BuyerMaster.prototype.buyerId,
//   BuyerMasterRelations
// > {
//   constructor(
//     @inject('datasources.dblello') dataSource: DblelloDataSource,
//   ) {
//     super(BuyerMaster, dataSource);
//   }
// }
// new code relation
const core_1 = require("@loopback/core");
const repository_1 = require("@loopback/repository");
const datasources_1 = require("../datasources");
const models_1 = require("../models");
let BuyerMasterRepository = class BuyerMasterRepository extends repository_1.DefaultCrudRepository {
    constructor(dataSource, cityRepoGetter, genderRepoGetter, usertypeRepoGetter) {
        super(models_1.BuyerMaster, dataSource);
        this.cityRepoGetter = cityRepoGetter;
        this.genderRepoGetter = genderRepoGetter;
        this.usertypeRepoGetter = usertypeRepoGetter;
        // Create BelongsTo accessors
        this.city = this.createBelongsToAccessorFor('city', cityRepoGetter);
        this.gender = this.createBelongsToAccessorFor('gender', genderRepoGetter);
        this.usertype = this.createBelongsToAccessorFor('usertype', usertypeRepoGetter);
        // Register inclusion resolvers
        this.registerInclusionResolver('city', this.city.inclusionResolver);
        this.registerInclusionResolver('gender', this.gender.inclusionResolver);
        this.registerInclusionResolver('usertype', this.usertype.inclusionResolver);
    }
};
exports.BuyerMasterRepository = BuyerMasterRepository;
exports.BuyerMasterRepository = BuyerMasterRepository = tslib_1.__decorate([
    tslib_1.__param(0, (0, core_1.inject)('datasources.dblello')),
    tslib_1.__param(1, repository_1.repository.getter('CityMasterRepository')),
    tslib_1.__param(2, repository_1.repository.getter('GenderMasterRepository')),
    tslib_1.__param(3, repository_1.repository.getter('UsertypeRepository')),
    tslib_1.__metadata("design:paramtypes", [datasources_1.DblelloDataSource, Function, Function, Function])
], BuyerMasterRepository);
//# sourceMappingURL=buyer-master.repository.js.map