"use strict";
/* eslint-disable @typescript-eslint/no-explicit-any */
// src/models/package-purchase.model.ts
// FIXED VERSION - Correct column name mapping
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackagePurchase = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const package_master_model_1 = require("./package-master.model");
let PackagePurchase = class PackagePurchase extends repository_1.Entity {
    constructor(data) {
        super(data);
    }
};
exports.PackagePurchase = PackagePurchase;
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: false },
        precision: 10,
        scale: 0,
        generated: 1,
        id: 1,
        mysql: { columnName: 'package_purchaseId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: 1 },
    }),
    tslib_1.__metadata("design:type", Number)
], PackagePurchase.prototype, "packagePurchaseId", void 0);
tslib_1.__decorate([
    (0, repository_1.belongsTo)(() => package_master_model_1.PackageMaster, { name: 'package' }, {
        type: 'number',
        required: true,
        jsonSchema: { nullable: false },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'fk_packageId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PackagePurchase.prototype, "fkPackageId", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        required: true,
        jsonSchema: { nullable: false },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'fk_buyerId_sellerId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PackagePurchase.prototype, "fkBuyerIdSellerId", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        required: true,
        jsonSchema: { nullable: false },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'fk_usertypeId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PackagePurchase.prototype, "fkUsertypeId", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        required: true,
        jsonSchema: { nullable: false },
        generated: false,
        mysql: { columnName: 'Date', dataType: 'date', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], PackagePurchase.prototype, "date", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'string',
        required: true,
        jsonSchema: { nullable: false },
        generated: false,
        mysql: { columnName: 'Time', dataType: 'time', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], PackagePurchase.prototype, "time", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'payment_Fag', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PackagePurchase.prototype, "paymentFag", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'string',
        jsonSchema: { nullable: true },
        length: 100,
        generated: false,
        mysql: { columnName: 'payment_No', dataType: 'varchar', dataLength: 100, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], PackagePurchase.prototype, "paymentNo", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        required: true,
        jsonSchema: { nullable: false },
        precision: 19,
        scale: 0,
        generated: false,
        mysql: { columnName: 'payment_Amount', dataType: 'bigint', dataLength: null, dataPrecision: 19, dataScale: 0, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PackagePurchase.prototype, "paymentAmount", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'property_Visit', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PackagePurchase.prototype, "propertyVisit", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'property_AddToCart', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PackagePurchase.prototype, "propertyAddToCart", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        required: true,
        jsonSchema: { nullable: false },
        generated: false,
        mysql: { columnName: 'package_End_Date', dataType: 'date', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], PackagePurchase.prototype, "packageEndDate", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 3,
        scale: 0,
        generated: false,
        mysql: { columnName: 'is_default', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PackagePurchase.prototype, "isDefault", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 3,
        scale: 0,
        generated: false,
        mysql: { columnName: 'is_on', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PackagePurchase.prototype, "isOn", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 3,
        scale: 0,
        generated: false,
        mysql: { columnName: 'is_active', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PackagePurchase.prototype, "isActive", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        jsonSchema: { nullable: true },
        generated: false,
        mysql: { columnName: 'created_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], PackagePurchase.prototype, "createdDate", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'created_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PackagePurchase.prototype, "createdBy", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        jsonSchema: { nullable: true },
        generated: false,
        mysql: { columnName: 'modified_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], PackagePurchase.prototype, "modifiedDate", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'modified_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PackagePurchase.prototype, "modifiedBy", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        jsonSchema: { nullable: true },
        generated: false,
        mysql: { columnName: 'deleted_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], PackagePurchase.prototype, "deletedDate", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'deleted_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], PackagePurchase.prototype, "deletedBy", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'string',
        jsonSchema: { nullable: true },
        length: 200,
        generated: false,
        mysql: { columnName: 'delete_remark', dataType: 'varchar', dataLength: 200, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], PackagePurchase.prototype, "deleteRemark", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        required: true,
        jsonSchema: { nullable: false },
        generated: false,
        mysql: { columnName: 'last_changed', dataType: 'timestamp', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], PackagePurchase.prototype, "lastChanged", void 0);
exports.PackagePurchase = PackagePurchase = tslib_1.__decorate([
    (0, repository_1.model)({
        settings: {
            idInjection: false,
            mysql: { schema: 'lelloproperty', table: 'package_purchase' },
            hiddenProperties: [
                'isDefault',
                'isOn',
                'isActive',
                'createdDate',
                'createdBy',
                'modifiedDate',
                'modifiedBy',
                'deletedDate',
                'deletedBy',
                'deleteRemark',
                'lastChanged',
            ],
        }
    }),
    tslib_1.__metadata("design:paramtypes", [Object])
], PackagePurchase);
//# sourceMappingURL=package-purchase.model.js.map