"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogBuyer = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const buyer_master_model_1 = require("./buyer-master.model");
const post_property_master_model_1 = require("./post-property-master.model");
let LogBuyer = class LogBuyer extends repository_1.Entity {
    constructor(data) {
        super(data);
    }
};
exports.LogBuyer = LogBuyer;
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: false },
        precision: 10,
        scale: 0,
        generated: 1,
        id: 1,
        mysql: { columnName: 'log_buyerId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: 1 },
    }),
    tslib_1.__metadata("design:type", Number)
], LogBuyer.prototype, "logBuyerId", void 0);
tslib_1.__decorate([
    (0, repository_1.belongsTo)(() => post_property_master_model_1.PostPropertyMaster, { name: 'postProperty' }, {
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'fk_postpropertyId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], LogBuyer.prototype, "fkPostpropertyId", void 0);
tslib_1.__decorate([
    (0, repository_1.belongsTo)(() => buyer_master_model_1.BuyerMaster, { name: 'buyer' }, {
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'fk_buyerId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], LogBuyer.prototype, "fkBuyerId", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        required: true,
        jsonSchema: { nullable: false },
        generated: false,
        mysql: { columnName: 'Date', dataType: 'date', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], LogBuyer.prototype, "date", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'string',
        required: true,
        jsonSchema: { nullable: false },
        generated: false,
        mysql: { columnName: 'Time', dataType: 'time', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], LogBuyer.prototype, "time", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 3,
        scale: 0,
        generated: false,
        mysql: { columnName: 'is_default', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], LogBuyer.prototype, "isDefault", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 3,
        scale: 0,
        generated: false,
        mysql: { columnName: 'is_on', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], LogBuyer.prototype, "isOn", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 3,
        scale: 0,
        generated: false,
        mysql: { columnName: 'is_active', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], LogBuyer.prototype, "isActive", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        jsonSchema: { nullable: true },
        generated: false,
        mysql: { columnName: 'created_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], LogBuyer.prototype, "createdDate", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'created_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], LogBuyer.prototype, "createdBy", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        jsonSchema: { nullable: true },
        generated: false,
        mysql: { columnName: 'modified_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], LogBuyer.prototype, "modifiedDate", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'modified_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], LogBuyer.prototype, "modifiedBy", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        jsonSchema: { nullable: true },
        generated: false,
        mysql: { columnName: 'deleted_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], LogBuyer.prototype, "deletedDate", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'deleted_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], LogBuyer.prototype, "deletedBy", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'string',
        jsonSchema: { nullable: true },
        length: 200,
        generated: false,
        mysql: { columnName: 'delete_remark', dataType: 'varchar', dataLength: 200, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], LogBuyer.prototype, "deleteRemark", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        required: true,
        jsonSchema: { nullable: false },
        generated: false,
        mysql: { columnName: 'last_changed', dataType: 'timestamp', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], LogBuyer.prototype, "lastChanged", void 0);
exports.LogBuyer = LogBuyer = tslib_1.__decorate([
    (0, repository_1.model)({
        settings: { idInjection: false, mysql: { schema: 'lelloproperty', table: 'log_buyer' } }
    }),
    tslib_1.__metadata("design:paramtypes", [Object])
], LogBuyer);
//# sourceMappingURL=log-buyer.model.js.map