"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdsManagement = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const ads_type_master_model_1 = require("./ads-type-master.model");
let AdsManagement = class AdsManagement extends repository_1.Entity {
    constructor(data) {
        super(data);
    }
};
exports.AdsManagement = AdsManagement;
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: false },
        precision: 10,
        scale: 0,
        generated: 1,
        id: 1,
        mysql: { columnName: 'adsId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: 1 },
    }),
    tslib_1.__metadata("design:type", Number)
], AdsManagement.prototype, "adsId", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        required: false,
        mysql: { columnName: 'fksellerId', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], AdsManagement.prototype, "fksellerId", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'string',
        required: true,
        jsonSchema: { nullable: false },
        length: 255,
        generated: false,
        mysql: { columnName: 'adsTitle', dataType: 'varchar', dataLength: 255, dataPrecision: null, dataScale: null, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], AdsManagement.prototype, "adsTitle", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'string',
        required: false,
        jsonSchema: { nullable: false },
        length: 65535,
        generated: false,
        mysql: { columnName: 'adsPhoto', dataType: 'text', dataLength: 65535, dataPrecision: null, dataScale: null, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], AdsManagement.prototype, "adsPhoto", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        jsonSchema: { nullable: true },
        generated: false,
        required: false,
        format: 'date-time',
        mysql: { columnName: 'adsStartDate', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Date)
], AdsManagement.prototype, "adsStartDate", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        jsonSchema: { nullable: true },
        generated: false,
        required: false,
        format: 'date-time',
        mysql: { columnName: 'adsEndDate', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Date)
], AdsManagement.prototype, "adsEndDate", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        // required: true,
        jsonSchema: { nullable: false },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'publish_Fag', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'N', generated: false },
    })
    // eslint-disable-next-line @typescript-eslint/naming-convention
    ,
    tslib_1.__metadata("design:type", Number)
], AdsManagement.prototype, "publish_Fag", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 3,
        scale: 0,
        generated: false,
        mysql: { columnName: 'is_default', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], AdsManagement.prototype, "isDefault", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 3,
        scale: 0,
        generated: false,
        mysql: { columnName: 'is_on', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], AdsManagement.prototype, "isOn", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 3,
        scale: 0,
        generated: false,
        mysql: { columnName: 'is_active', dataType: 'tinyint', dataLength: null, dataPrecision: 3, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], AdsManagement.prototype, "isActive", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        jsonSchema: { nullable: true },
        generated: false,
        mysql: { columnName: 'created_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], AdsManagement.prototype, "createdDate", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'created_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], AdsManagement.prototype, "createdBy", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        jsonSchema: { nullable: true },
        generated: false,
        mysql: { columnName: 'modified_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], AdsManagement.prototype, "modifiedDate", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'modified_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], AdsManagement.prototype, "modifiedBy", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        jsonSchema: { nullable: true },
        generated: false,
        mysql: { columnName: 'deleted_date', dataType: 'datetime', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], AdsManagement.prototype, "deletedDate", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'number',
        jsonSchema: { nullable: true },
        precision: 10,
        scale: 0,
        generated: false,
        mysql: { columnName: 'deleted_by', dataType: 'int', dataLength: null, dataPrecision: 10, dataScale: 0, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", Number)
], AdsManagement.prototype, "deletedBy", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'string',
        jsonSchema: { nullable: true },
        length: 200,
        generated: false,
        mysql: { columnName: 'delete_remark', dataType: 'varchar', dataLength: 200, dataPrecision: null, dataScale: null, nullable: 'Y', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], AdsManagement.prototype, "deleteRemark", void 0);
tslib_1.__decorate([
    (0, repository_1.property)({
        type: 'date',
        required: true,
        jsonSchema: { nullable: false },
        generated: false,
        mysql: { columnName: 'last_changed', dataType: 'timestamp', dataLength: null, dataPrecision: null, dataScale: null, nullable: 'N', generated: false },
    }),
    tslib_1.__metadata("design:type", String)
], AdsManagement.prototype, "lastChanged", void 0);
tslib_1.__decorate([
    (0, repository_1.belongsTo)(() => ads_type_master_model_1.AdsTypeMaster, { name: 'adsType' }),
    tslib_1.__metadata("design:type", Number)
], AdsManagement.prototype, "fkadsTypeId", void 0);
exports.AdsManagement = AdsManagement = tslib_1.__decorate([
    (0, repository_1.model)({
        settings: { idInjection: false, mysql: { schema: 'lelloproperty', table: 'ads_management' } }
    }),
    tslib_1.__metadata("design:paramtypes", [Object])
], AdsManagement);
//# sourceMappingURL=ads-management.model.js.map