"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransactionTypeMasterController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let TransactionTypeMasterController = class TransactionTypeMasterController {
    constructor(transactionTypeMasterRepository) {
        this.transactionTypeMasterRepository = transactionTypeMasterRepository;
    }
    async create(transactionTypeMaster) {
        return this.transactionTypeMasterRepository.create(transactionTypeMaster);
    }
    async count(where) {
        return this.transactionTypeMasterRepository.count(where);
    }
    async find(filter) {
        return this.transactionTypeMasterRepository.find(filter);
    }
    async updateAll(transactionTypeMaster, where) {
        return this.transactionTypeMasterRepository.updateAll(transactionTypeMaster, where);
    }
    async findById(id, filter) {
        return this.transactionTypeMasterRepository.findById(id, filter);
    }
    async updateById(id, transactionTypeMaster) {
        await this.transactionTypeMasterRepository.updateById(id, transactionTypeMaster);
    }
    async replaceById(id, transactionTypeMaster) {
        await this.transactionTypeMasterRepository.replaceById(id, transactionTypeMaster);
    }
    async deleteById(id) {
        await this.transactionTypeMasterRepository.deleteById(id);
    }
};
exports.TransactionTypeMasterController = TransactionTypeMasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/transaction-type-masters'),
    (0, rest_1.response)(200, {
        description: 'TransactionTypeMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.TransactionTypeMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.TransactionTypeMaster, {
                    title: 'NewTransactionTypeMaster',
                    exclude: ['transactionId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], TransactionTypeMasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/transaction-type-masters/count'),
    (0, rest_1.response)(200, {
        description: 'TransactionTypeMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.TransactionTypeMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], TransactionTypeMasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/transaction-type-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of TransactionTypeMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.TransactionTypeMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.TransactionTypeMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], TransactionTypeMasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/transaction-type-masters'),
    (0, rest_1.response)(200, {
        description: 'TransactionTypeMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.TransactionTypeMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.TransactionTypeMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.TransactionTypeMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], TransactionTypeMasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/transaction-type-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'TransactionTypeMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.TransactionTypeMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.TransactionTypeMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], TransactionTypeMasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/transaction-type-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'TransactionTypeMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.TransactionTypeMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.TransactionTypeMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], TransactionTypeMasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/transaction-type-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'TransactionTypeMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.TransactionTypeMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], TransactionTypeMasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/transaction-type-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'TransactionTypeMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], TransactionTypeMasterController.prototype, "deleteById", null);
exports.TransactionTypeMasterController = TransactionTypeMasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.TransactionTypeMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.TransactionTypeMasterRepository])
], TransactionTypeMasterController);
//# sourceMappingURL=transaction-type-master.controller.js.map