import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { TransactionTypeMaster } from '../models';
import { TransactionTypeMasterRepository } from '../repositories';
export declare class TransactionTypeMasterController {
    transactionTypeMasterRepository: TransactionTypeMasterRepository;
    constructor(transactionTypeMasterRepository: TransactionTypeMasterRepository);
    create(transactionTypeMaster: Omit<TransactionTypeMaster, 'transactionId'>): Promise<TransactionTypeMaster>;
    count(where?: Where<TransactionTypeMaster>): Promise<Count>;
    find(filter?: Filter<TransactionTypeMaster>): Promise<TransactionTypeMaster[]>;
    updateAll(transactionTypeMaster: TransactionTypeMaster, where?: Where<TransactionTypeMaster>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<TransactionTypeMaster>): Promise<TransactionTypeMaster>;
    updateById(id: number, transactionTypeMaster: TransactionTypeMaster): Promise<void>;
    replaceById(id: number, transactionTypeMaster: TransactionTypeMaster): Promise<void>;
    deleteById(id: number): Promise<void>;
}
