"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TitlemasterController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let TitlemasterController = class TitlemasterController {
    constructor(titleMasterRepository) {
        this.titleMasterRepository = titleMasterRepository;
    }
    async create(titleMaster) {
        return this.titleMasterRepository.create(titleMaster);
    }
    async count(where) {
        return this.titleMasterRepository.count(where);
    }
    async find(filter) {
        return this.titleMasterRepository.find(filter);
    }
    async updateAll(titleMaster, where) {
        return this.titleMasterRepository.updateAll(titleMaster, where);
    }
    async findById(id, filter) {
        return this.titleMasterRepository.findById(id, filter);
    }
    async updateById(id, titleMaster) {
        await this.titleMasterRepository.updateById(id, titleMaster);
    }
    async replaceById(id, titleMaster) {
        await this.titleMasterRepository.replaceById(id, titleMaster);
    }
    async deleteById(id) {
        await this.titleMasterRepository.deleteById(id);
    }
};
exports.TitlemasterController = TitlemasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/title-masters'),
    (0, rest_1.response)(200, {
        description: 'TitleMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.TitleMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.TitleMaster, {
                    title: 'NewTitleMaster',
                    exclude: ['titleId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], TitlemasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/title-masters/count'),
    (0, rest_1.response)(200, {
        description: 'TitleMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.TitleMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], TitlemasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/title-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of TitleMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.TitleMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.TitleMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], TitlemasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/title-masters'),
    (0, rest_1.response)(200, {
        description: 'TitleMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.TitleMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.TitleMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.TitleMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], TitlemasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/title-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'TitleMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.TitleMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.TitleMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], TitlemasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/title-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'TitleMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.TitleMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.TitleMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], TitlemasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/title-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'TitleMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.TitleMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], TitlemasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/title-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'TitleMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], TitlemasterController.prototype, "deleteById", null);
exports.TitlemasterController = TitlemasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.TitleMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.TitleMasterRepository])
], TitlemasterController);
//# sourceMappingURL=titlemaster.controller.js.map