import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { TitleMaster } from '../models';
import { TitleMasterRepository } from '../repositories';
export declare class TitlemasterController {
    titleMasterRepository: TitleMasterRepository;
    constructor(titleMasterRepository: TitleMasterRepository);
    create(titleMaster: Omit<TitleMaster, 'titleId'>): Promise<TitleMaster>;
    count(where?: Where<TitleMaster>): Promise<Count>;
    find(filter?: Filter<TitleMaster>): Promise<TitleMaster[]>;
    updateAll(titleMaster: TitleMaster, where?: Where<TitleMaster>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<TitleMaster>): Promise<TitleMaster>;
    updateById(id: number, titleMaster: TitleMaster): Promise<void>;
    replaceById(id: number, titleMaster: TitleMaster): Promise<void>;
    deleteById(id: number): Promise<void>;
}
