"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RecommendedpropertiesController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let RecommendedpropertiesController = class RecommendedpropertiesController {
    constructor(recommendedPropertiesRepository) {
        this.recommendedPropertiesRepository = recommendedPropertiesRepository;
    }
    async create(recommendedProperties) {
        return this.recommendedPropertiesRepository.create(recommendedProperties);
    }
    async count(where) {
        return this.recommendedPropertiesRepository.count(where);
    }
    async find(filter) {
        return this.recommendedPropertiesRepository.find(filter);
    }
    async updateAll(recommendedProperties, where) {
        return this.recommendedPropertiesRepository.updateAll(recommendedProperties, where);
    }
    async findById(id, filter) {
        return this.recommendedPropertiesRepository.findById(id, filter);
    }
    async updateById(id, recommendedProperties) {
        await this.recommendedPropertiesRepository.updateById(id, recommendedProperties);
    }
    async replaceById(id, recommendedProperties) {
        await this.recommendedPropertiesRepository.replaceById(id, recommendedProperties);
    }
    async deleteById(id) {
        await this.recommendedPropertiesRepository.deleteById(id);
    }
};
exports.RecommendedpropertiesController = RecommendedpropertiesController;
tslib_1.__decorate([
    (0, rest_1.post)('/recommended-properties'),
    (0, rest_1.response)(200, {
        description: 'RecommendedProperties model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.RecommendedProperties) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.RecommendedProperties, {
                    title: 'NewRecommendedProperties',
                    exclude: ['recommendPropId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], RecommendedpropertiesController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/recommended-properties/count'),
    (0, rest_1.response)(200, {
        description: 'RecommendedProperties model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.RecommendedProperties)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], RecommendedpropertiesController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/recommended-properties'),
    (0, rest_1.response)(200, {
        description: 'Array of RecommendedProperties model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.RecommendedProperties, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.RecommendedProperties)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], RecommendedpropertiesController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/recommended-properties'),
    (0, rest_1.response)(200, {
        description: 'RecommendedProperties PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.RecommendedProperties, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.RecommendedProperties)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.RecommendedProperties, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], RecommendedpropertiesController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/recommended-properties/{id}'),
    (0, rest_1.response)(200, {
        description: 'RecommendedProperties model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.RecommendedProperties, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.RecommendedProperties, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], RecommendedpropertiesController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/recommended-properties/{id}'),
    (0, rest_1.response)(204, {
        description: 'RecommendedProperties PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.RecommendedProperties, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.RecommendedProperties]),
    tslib_1.__metadata("design:returntype", Promise)
], RecommendedpropertiesController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/recommended-properties/{id}'),
    (0, rest_1.response)(204, {
        description: 'RecommendedProperties PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.RecommendedProperties]),
    tslib_1.__metadata("design:returntype", Promise)
], RecommendedpropertiesController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/recommended-properties/{id}'),
    (0, rest_1.response)(204, {
        description: 'RecommendedProperties DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], RecommendedpropertiesController.prototype, "deleteById", null);
exports.RecommendedpropertiesController = RecommendedpropertiesController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.RecommendedPropertiesRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.RecommendedPropertiesRepository])
], RecommendedpropertiesController);
//# sourceMappingURL=recommendedproperties.controller.js.map