import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { RecommendedProperties } from '../models';
import { RecommendedPropertiesRepository } from '../repositories';
export declare class RecommendedpropertiesController {
    recommendedPropertiesRepository: RecommendedPropertiesRepository;
    constructor(recommendedPropertiesRepository: RecommendedPropertiesRepository);
    create(recommendedProperties: Omit<RecommendedProperties, 'recommendPropId'>): Promise<RecommendedProperties>;
    count(where?: Where<RecommendedProperties>): Promise<Count>;
    find(filter?: Filter<RecommendedProperties>): Promise<RecommendedProperties[]>;
    updateAll(recommendedProperties: RecommendedProperties, where?: Where<RecommendedProperties>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<RecommendedProperties>): Promise<RecommendedProperties>;
    updateById(id: number, recommendedProperties: RecommendedProperties): Promise<void>;
    replaceById(id: number, recommendedProperties: RecommendedProperties): Promise<void>;
    deleteById(id: number): Promise<void>;
}
