"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RecommendedlaunchController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let RecommendedlaunchController = class RecommendedlaunchController {
    constructor(recommendedLaunchRepository) {
        this.recommendedLaunchRepository = recommendedLaunchRepository;
    }
    async create(recommendedLaunch) {
        return this.recommendedLaunchRepository.create(recommendedLaunch);
    }
    async count(where) {
        return this.recommendedLaunchRepository.count(where);
    }
    async find(filter) {
        return this.recommendedLaunchRepository.find({ include: [{ relation: 'postproperty' }],
            ...filter, });
    }
    async updateAll(recommendedLaunch, where) {
        return this.recommendedLaunchRepository.updateAll(recommendedLaunch, where);
    }
    async findById(id, filter) {
        return this.recommendedLaunchRepository.findById(id, filter);
    }
    async updateById(id, recommendedLaunch) {
        await this.recommendedLaunchRepository.updateById(id, recommendedLaunch);
    }
    async replaceById(id, recommendedLaunch) {
        await this.recommendedLaunchRepository.replaceById(id, recommendedLaunch);
    }
    async deleteById(id) {
        await this.recommendedLaunchRepository.deleteById(id);
    }
};
exports.RecommendedlaunchController = RecommendedlaunchController;
tslib_1.__decorate([
    (0, rest_1.post)('/recommended-launches'),
    (0, rest_1.response)(200, {
        description: 'RecommendedLaunch model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.RecommendedLaunch) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.RecommendedLaunch, {
                    title: 'NewRecommendedLaunch',
                    exclude: ['reclaunchId '],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], RecommendedlaunchController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/recommended-launches/count'),
    (0, rest_1.response)(200, {
        description: 'RecommendedLaunch model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.RecommendedLaunch)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], RecommendedlaunchController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/recommended-launches'),
    (0, rest_1.response)(200, {
        description: 'Array of RecommendedLaunch model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.RecommendedLaunch, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.RecommendedLaunch)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], RecommendedlaunchController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/recommended-launches'),
    (0, rest_1.response)(200, {
        description: 'RecommendedLaunch PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.RecommendedLaunch, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.RecommendedLaunch)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.RecommendedLaunch, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], RecommendedlaunchController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/recommended-launches/{id}'),
    (0, rest_1.response)(200, {
        description: 'RecommendedLaunch model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.RecommendedLaunch, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.RecommendedLaunch, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], RecommendedlaunchController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/recommended-launches/{id}'),
    (0, rest_1.response)(204, {
        description: 'RecommendedLaunch PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.RecommendedLaunch, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.RecommendedLaunch]),
    tslib_1.__metadata("design:returntype", Promise)
], RecommendedlaunchController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/recommended-launches/{id}'),
    (0, rest_1.response)(204, {
        description: 'RecommendedLaunch PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.RecommendedLaunch]),
    tslib_1.__metadata("design:returntype", Promise)
], RecommendedlaunchController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/recommended-launches/{id}'),
    (0, rest_1.response)(204, {
        description: 'RecommendedLaunch DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], RecommendedlaunchController.prototype, "deleteById", null);
exports.RecommendedlaunchController = RecommendedlaunchController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.RecommendedLaunchRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.RecommendedLaunchRepository])
], RecommendedlaunchController);
//# sourceMappingURL=recommendedlaunch.controller.js.map