/// <reference types="express" />
import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { Request, Response } from '@loopback/rest';
import { RealEstateMaster } from '../models';
import { RealEstateMasterRepository } from '../repositories';
export declare class RealestetemasterController {
    realEstateMasterRepository: RealEstateMasterRepository;
    constructor(realEstateMasterRepository: RealEstateMasterRepository);
    /**
     * ✅ Create real estate with only JSON (no file)
     */
    create(realEstateMaster: Omit<RealEstateMaster, 'blogId'>): Promise<RealEstateMaster>;
    /**
     * ✅ Create real estate with image upload (multipart/form-data)
     */
    createWithImage(request: Request, response: Response): Promise<any>;
    /**
     * ✅ Fetch all with image URL resolution
     */
    find(filter?: Filter<RealEstateMaster>): Promise<any[]>;
    count(where?: Where<RealEstateMaster>): Promise<Count>;
    updateAll(realEstateMaster: RealEstateMaster, where?: Where<RealEstateMaster>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<RealEstateMaster>): Promise<RealEstateMaster>;
    updateById(id: number, realEstateMaster: RealEstateMaster): Promise<void>;
    replaceById(id: number, realEstateMaster: RealEstateMaster): Promise<void>;
    deleteById(id: number): Promise<void>;
}
