import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { PublishTypeMaster } from '../models';
import { PublishTypeMasterRepository } from '../repositories';
export declare class PublishTypeMasterController {
    publishTypeMasterRepository: PublishTypeMasterRepository;
    constructor(publishTypeMasterRepository: PublishTypeMasterRepository);
    create(publishTypeMaster: Omit<PublishTypeMaster, 'publishTypeId'>): Promise<PublishTypeMaster>;
    count(where?: Where<PublishTypeMaster>): Promise<Count>;
    find(filter?: Filter<PublishTypeMaster>): Promise<PublishTypeMaster[]>;
    updateAll(publishTypeMaster: PublishTypeMaster, where?: Where<PublishTypeMaster>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<PublishTypeMaster>): Promise<PublishTypeMaster>;
    updateById(id: number, publishTypeMaster: PublishTypeMaster): Promise<void>;
    replaceById(id: number, publishTypeMaster: PublishTypeMaster): Promise<void>;
    deleteById(id: number): Promise<void>;
}
