"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProprtylistingmasterController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let ProprtylistingmasterController = class ProprtylistingmasterController {
    constructor(propertylistingMasterRepository) {
        this.propertylistingMasterRepository = propertylistingMasterRepository;
    }
    async create(propertylistingMaster) {
        return this.propertylistingMasterRepository.create(propertylistingMaster);
    }
    async count(where) {
        return this.propertylistingMasterRepository.count(where);
    }
    async find(filter) {
        return this.propertylistingMasterRepository.find(filter);
    }
    async updateAll(propertylistingMaster, where) {
        return this.propertylistingMasterRepository.updateAll(propertylistingMaster, where);
    }
    async findById(id, filter) {
        return this.propertylistingMasterRepository.findById(id, filter);
    }
    async updateById(id, propertylistingMaster) {
        await this.propertylistingMasterRepository.updateById(id, propertylistingMaster);
    }
    async replaceById(id, propertylistingMaster) {
        await this.propertylistingMasterRepository.replaceById(id, propertylistingMaster);
    }
    async deleteById(id) {
        await this.propertylistingMasterRepository.deleteById(id);
    }
};
exports.ProprtylistingmasterController = ProprtylistingmasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/propertylisting-masters'),
    (0, rest_1.response)(200, {
        description: 'PropertylistingMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.PropertylistingMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PropertylistingMaster, {
                    title: 'NewPropertylistingMaster',
                    exclude: ['propertylistId	'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], ProprtylistingmasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/propertylisting-masters/count'),
    (0, rest_1.response)(200, {
        description: 'PropertylistingMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.PropertylistingMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], ProprtylistingmasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/propertylisting-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of PropertylistingMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.PropertylistingMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.PropertylistingMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], ProprtylistingmasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/propertylisting-masters'),
    (0, rest_1.response)(200, {
        description: 'PropertylistingMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PropertylistingMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.PropertylistingMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.PropertylistingMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], ProprtylistingmasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/propertylisting-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'PropertylistingMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PropertylistingMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.PropertylistingMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], ProprtylistingmasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/propertylisting-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'PropertylistingMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PropertylistingMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.PropertylistingMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], ProprtylistingmasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/propertylisting-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'PropertylistingMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.PropertylistingMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], ProprtylistingmasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/propertylisting-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'PropertylistingMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], ProprtylistingmasterController.prototype, "deleteById", null);
exports.ProprtylistingmasterController = ProprtylistingmasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.PropertylistingMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.PropertylistingMasterRepository])
], ProprtylistingmasterController);
//# sourceMappingURL=proprtylistingmaster.controller.js.map