"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PropertytypemasterController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let PropertytypemasterController = class PropertytypemasterController {
    constructor(propertyTypeMasterRepository) {
        this.propertyTypeMasterRepository = propertyTypeMasterRepository;
    }
    async create(propertyTypeMaster) {
        return this.propertyTypeMasterRepository.create(propertyTypeMaster);
    }
    async count(where) {
        return this.propertyTypeMasterRepository.count(where);
    }
    async find(filter) {
        return this.propertyTypeMasterRepository.find(filter);
    }
    async updateAll(propertyTypeMaster, where) {
        return this.propertyTypeMasterRepository.updateAll(propertyTypeMaster, where);
    }
    async findById(id, filter) {
        return this.propertyTypeMasterRepository.findById(id, filter);
    }
    async updateById(id, propertyTypeMaster) {
        await this.propertyTypeMasterRepository.updateById(id, propertyTypeMaster);
    }
    async replaceById(id, propertyTypeMaster) {
        await this.propertyTypeMasterRepository.replaceById(id, propertyTypeMaster);
    }
    async deleteById(id) {
        await this.propertyTypeMasterRepository.deleteById(id);
    }
};
exports.PropertytypemasterController = PropertytypemasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/property-type-masters'),
    (0, rest_1.response)(200, {
        description: 'PropertyTypeMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.PropertyTypeMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PropertyTypeMaster, {
                    title: 'NewPropertyTypeMaster',
                    exclude: ['propertyTypeId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PropertytypemasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/property-type-masters/count'),
    (0, rest_1.response)(200, {
        description: 'PropertyTypeMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.PropertyTypeMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PropertytypemasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/property-type-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of PropertyTypeMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.PropertyTypeMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.PropertyTypeMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PropertytypemasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/property-type-masters'),
    (0, rest_1.response)(200, {
        description: 'PropertyTypeMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PropertyTypeMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.PropertyTypeMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.PropertyTypeMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PropertytypemasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/property-type-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'PropertyTypeMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PropertyTypeMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.PropertyTypeMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PropertytypemasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/property-type-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'PropertyTypeMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PropertyTypeMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.PropertyTypeMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], PropertytypemasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/property-type-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'PropertyTypeMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.PropertyTypeMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], PropertytypemasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/property-type-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'PropertyTypeMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], PropertytypemasterController.prototype, "deleteById", null);
exports.PropertytypemasterController = PropertytypemasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.PropertyTypeMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.PropertyTypeMasterRepository])
], PropertytypemasterController);
//# sourceMappingURL=propertytypemaster.controller.js.map