"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostPropertyAmenitiesController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let PostPropertyAmenitiesController = class PostPropertyAmenitiesController {
    constructor(postPropertyAmenitiesRepository) {
        this.postPropertyAmenitiesRepository = postPropertyAmenitiesRepository;
    }
    async create(postPropertyAmenities) {
        return this.postPropertyAmenitiesRepository.create(postPropertyAmenities);
    }
    async count(where) {
        return this.postPropertyAmenitiesRepository.count(where);
    }
    async find(filter) {
        const newFilter = {
            ...filter,
            fields: {
                isDefault: false,
                isOn: false,
                isActive: false,
                createdDate: false,
                createdBy: false,
                modifiedDate: false,
                modifiedBy: false,
                deletedDate: false,
                deletedBy: false,
                deleteRemark: false,
                lastChanged: false,
            },
            include: [
                {
                    relation: 'postProperty',
                    scope: {
                        fields: {
                            isDefault: false,
                            isOn: false,
                            isActive: false,
                            createdDate: false,
                            createdBy: false,
                            modifiedDate: false,
                            modifiedBy: false,
                            deletedDate: false,
                            deletedBy: false,
                            deleteRemark: false,
                            lastChanged: false,
                        }
                    }
                },
                {
                    relation: 'amenity',
                    scope: {
                        fields: {
                            isDefault: false,
                            isOn: false,
                            isActive: false,
                            createdDate: false,
                            createdBy: false,
                            modifiedDate: false,
                            modifiedBy: false,
                            deletedDate: false,
                            deletedBy: false,
                            deleteRemark: false,
                            lastChanged: false,
                        }
                    }
                }
            ],
        };
        return this.postPropertyAmenitiesRepository.find(newFilter);
    }
    async updateAll(postPropertyAmenities, where) {
        return this.postPropertyAmenitiesRepository.updateAll(postPropertyAmenities, where);
    }
    async findById(id, filter) {
        const newFilter = {
            ...filter,
            fields: {
                isDefault: false,
                isOn: false,
                isActive: false,
                createdDate: false,
                createdBy: false,
                modifiedDate: false,
                modifiedBy: false,
                deletedDate: false,
                deletedBy: false,
                deleteRemark: false,
                lastChanged: false,
            },
            include: [
                {
                    relation: 'postProperty',
                    scope: {
                        fields: {
                            isDefault: false,
                            isOn: false,
                            isActive: false,
                            createdDate: false,
                            createdBy: false,
                            modifiedDate: false,
                            modifiedBy: false,
                            deletedDate: false,
                            deletedBy: false,
                            deleteRemark: false,
                            lastChanged: false,
                        }
                    }
                },
                {
                    relation: 'amenity',
                    scope: {
                        fields: {
                            isDefault: false,
                            isOn: false,
                            isActive: false,
                            createdDate: false,
                            createdBy: false,
                            modifiedDate: false,
                            modifiedBy: false,
                            deletedDate: false,
                            deletedBy: false,
                            deleteRemark: false,
                            lastChanged: false,
                        }
                    }
                }
            ],
        };
        return this.postPropertyAmenitiesRepository.findById(id, newFilter);
    }
    async updateById(id, postPropertyAmenities) {
        await this.postPropertyAmenitiesRepository.updateById(id, postPropertyAmenities);
    }
    async replaceById(id, postPropertyAmenities) {
        await this.postPropertyAmenitiesRepository.replaceById(id, postPropertyAmenities);
    }
    async deleteById(id) {
        await this.postPropertyAmenitiesRepository.deleteById(id);
    }
};
exports.PostPropertyAmenitiesController = PostPropertyAmenitiesController;
tslib_1.__decorate([
    (0, rest_1.post)('/post-property-amenities'),
    (0, rest_1.response)(200, {
        description: 'PostPropertyAmenities model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.PostPropertyAmenities) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PostPropertyAmenities, {
                    title: 'NewPostPropertyAmenities',
                    exclude: ['id'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PostPropertyAmenitiesController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/post-property-amenities/count'),
    (0, rest_1.response)(200, {
        description: 'PostPropertyAmenities model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.PostPropertyAmenities)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PostPropertyAmenitiesController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/post-property-amenities'),
    (0, rest_1.response)(200, {
        description: 'Array of PostPropertyAmenities model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.PostPropertyAmenities, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.PostPropertyAmenities)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PostPropertyAmenitiesController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/post-property-amenities'),
    (0, rest_1.response)(200, {
        description: 'PostPropertyAmenities PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PostPropertyAmenities, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.PostPropertyAmenities)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.PostPropertyAmenities, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PostPropertyAmenitiesController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/post-property-amenities/{id}'),
    (0, rest_1.response)(200, {
        description: 'PostPropertyAmenities model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PostPropertyAmenities, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.PostPropertyAmenities, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], PostPropertyAmenitiesController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/post-property-amenities/{id}'),
    (0, rest_1.response)(204, {
        description: 'PostPropertyAmenities PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.PostPropertyAmenities, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.PostPropertyAmenities]),
    tslib_1.__metadata("design:returntype", Promise)
], PostPropertyAmenitiesController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/post-property-amenities/{id}'),
    (0, rest_1.response)(204, {
        description: 'PostPropertyAmenities PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.PostPropertyAmenities]),
    tslib_1.__metadata("design:returntype", Promise)
], PostPropertyAmenitiesController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/post-property-amenities/{id}'),
    (0, rest_1.response)(204, {
        description: 'PostPropertyAmenities DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], PostPropertyAmenitiesController.prototype, "deleteById", null);
exports.PostPropertyAmenitiesController = PostPropertyAmenitiesController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.PostPropertyAmenitiesRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.PostPropertyAmenitiesRepository])
], PostPropertyAmenitiesController);
//# sourceMappingURL=post-property-amenities.controller.js.map