import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { PossessionMaster } from '../models';
import { PossessionMasterRepository } from '../repositories';
export declare class PossessionMasterController {
    possessionMasterRepository: PossessionMasterRepository;
    constructor(possessionMasterRepository: PossessionMasterRepository);
    create(possessionMaster: Omit<PossessionMaster, 'possessionId'>): Promise<PossessionMaster>;
    count(where?: Where<PossessionMaster>): Promise<Count>;
    find(filter?: Filter<PossessionMaster>): Promise<PossessionMaster[]>;
    updateAll(possessionMaster: PossessionMaster, where?: Where<PossessionMaster>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<PossessionMaster>): Promise<PossessionMaster>;
    updateById(id: number, possessionMaster: PossessionMaster): Promise<void>;
    replaceById(id: number, possessionMaster: PossessionMaster): Promise<void>;
    deleteById(id: number): Promise<void>;
}
