/// <reference types="express" />
import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { PackagePurchase } from '../models';
import { PackagePurchaseRepository } from '../repositories';
import { Request } from '@loopback/rest';
export declare class PackagePurchaseController {
    packagePurchaseRepository: PackagePurchaseRepository;
    private request;
    constructor(packagePurchaseRepository: PackagePurchaseRepository, request: Request);
    /**
     * Verify PhonePe payment and create package purchase
     */
    verifyPayment(paymentData: {
        transactionId: string;
        packageId: number;
        userId: number;
        amount: number;
        packageDuration?: number;
        propertyVisit?: number;
        propertyAddToCart?: number;
        usertypeId?: number;
        isDemoMode?: boolean;
    }): Promise<PackagePurchase>;
    /**
     * PhonePe callback endpoint
     */
    handleCallback(): Promise<object>;
    /**
     * Helper method to verify payment with PhonePe API
     */
    private verifyPhonePePayment;
    create(packagePurchase: Omit<PackagePurchase, 'packagePurchaseId'>): Promise<PackagePurchase>;
    count(where?: Where<PackagePurchase>): Promise<Count>;
    find(filter?: Filter<PackagePurchase>): Promise<PackagePurchase[]>;
    updateAll(packagePurchase: PackagePurchase, where?: Where<PackagePurchase>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<PackagePurchase>): Promise<PackagePurchase>;
    updateById(id: number, packagePurchase: PackagePurchase): Promise<void>;
    replaceById(id: number, packagePurchase: PackagePurchase): Promise<void>;
    deleteById(id: number): Promise<void>;
    getPackagesByUser(userId: number): Promise<PackagePurchase[]>;
}
