import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { OtpVerification } from '../models';
import { BuyerMasterRepository, OtpVerificationRepository, SellerMasterRepository } from '../repositories';
export declare class OtpverificationController {
    otpVerificationRepository: OtpVerificationRepository;
    buyerRepository: BuyerMasterRepository;
    sellerRepository: SellerMasterRepository;
    constructor(otpVerificationRepository: OtpVerificationRepository, buyerRepository: BuyerMasterRepository, sellerRepository: SellerMasterRepository);
    createOtp(body: {
        phone_number: string;
    }): Promise<object>;
    verifyOtp(body: {
        phone_number: string;
        otp: string;
    }): Promise<object>;
    checkUser(body: {
        phone_number: string;
    }): Promise<{
        source: 'buyer' | 'seller' | 'none';
        data: any | null;
    }>;
    find(filter?: Filter<OtpVerification>): Promise<OtpVerification[]>;
    updateAll(otpVerification: OtpVerification, where?: Where<OtpVerification>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<OtpVerification>): Promise<OtpVerification>;
    updateById(id: number, otpVerification: OtpVerification): Promise<void>;
    replaceById(id: number, otpVerification: OtpVerification): Promise<void>;
    deleteById(id: number): Promise<void>;
}
