"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NewlaunchmasterController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let NewlaunchmasterController = class NewlaunchmasterController {
    constructor(newLaunchMasterRepository) {
        this.newLaunchMasterRepository = newLaunchMasterRepository;
    }
    async create(newLaunchMaster) {
        return this.newLaunchMasterRepository.create(newLaunchMaster);
    }
    async count(where) {
        return this.newLaunchMasterRepository.count(where);
    }
    async find(filter) {
        return this.newLaunchMasterRepository.find({
            include: [{ relation: 'postproperty' }],
            ...filter,
        });
    }
    async updateAll(newLaunchMaster, where) {
        return this.newLaunchMasterRepository.updateAll(newLaunchMaster, where);
    }
    async findById(id, filter) {
        return this.newLaunchMasterRepository.findById(id, filter);
    }
    async updateById(id, newLaunchMaster) {
        await this.newLaunchMasterRepository.updateById(id, newLaunchMaster);
    }
    async replaceById(id, newLaunchMaster) {
        await this.newLaunchMasterRepository.replaceById(id, newLaunchMaster);
    }
    async deleteById(id) {
        await this.newLaunchMasterRepository.deleteById(id);
    }
};
exports.NewlaunchmasterController = NewlaunchmasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/new-launch-masters'),
    (0, rest_1.response)(200, {
        description: 'NewLaunchMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.NewLaunchMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.NewLaunchMaster, {
                    title: 'NewNewLaunchMaster',
                    exclude: ['newLaunchId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], NewlaunchmasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/new-launch-masters/count'),
    (0, rest_1.response)(200, {
        description: 'NewLaunchMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.NewLaunchMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], NewlaunchmasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/new-launch-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of NewLaunchMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.NewLaunchMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.NewLaunchMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], NewlaunchmasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/new-launch-masters'),
    (0, rest_1.response)(200, {
        description: 'NewLaunchMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.NewLaunchMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.NewLaunchMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.NewLaunchMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], NewlaunchmasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/new-launch-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'NewLaunchMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.NewLaunchMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.NewLaunchMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], NewlaunchmasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/new-launch-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'NewLaunchMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.NewLaunchMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.NewLaunchMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], NewlaunchmasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/new-launch-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'NewLaunchMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.NewLaunchMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], NewlaunchmasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/new-launch-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'NewLaunchMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], NewlaunchmasterController.prototype, "deleteById", null);
exports.NewlaunchmasterController = NewlaunchmasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.NewLaunchMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.NewLaunchMasterRepository])
], NewlaunchmasterController);
//# sourceMappingURL=newlaunchmaster.controller.js.map