/// <reference types="express" />
import { FilterExcludingWhere } from '@loopback/repository';
import { Request } from '@loopback/rest';
import { LogoMaster } from '../models';
import { LogoMasterRepository } from '../repositories';
export declare class LogomasterController {
    logoMasterRepository: LogoMasterRepository;
    private uploadPath;
    private storage;
    private upload;
    constructor(logoMasterRepository: LogoMasterRepository);
    /** CREATE with file upload */
    create(req: Request): Promise<LogoMaster>;
    /** GET all with full URL */
    find(): Promise<any[]>;
    /** GET by ID */
    findById(id: number, filter?: FilterExcludingWhere<LogoMaster>): Promise<LogoMaster>;
    /** UPDATE by ID with optional file upload */
    updateById(req: Request, id: number): Promise<void>;
    /** DELETE by ID and remove file */
    deleteById(id: number): Promise<void>;
}
