"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogBuyersearchController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let LogBuyersearchController = class LogBuyersearchController {
    constructor(logBuyersearchRepository) {
        this.logBuyersearchRepository = logBuyersearchRepository;
    }
    async create(logBuyersearch) {
        return this.logBuyersearchRepository.create(logBuyersearch);
    }
    async count(where) {
        return this.logBuyersearchRepository.count(where);
    }
    async find(filter) {
        return this.logBuyersearchRepository.find(filter);
    }
    async updateAll(logBuyersearch, where) {
        return this.logBuyersearchRepository.updateAll(logBuyersearch, where);
    }
    async findById(id, filter) {
        return this.logBuyersearchRepository.findById(id, filter);
    }
    async updateById(id, logBuyersearch) {
        await this.logBuyersearchRepository.updateById(id, logBuyersearch);
    }
    async replaceById(id, logBuyersearch) {
        await this.logBuyersearchRepository.replaceById(id, logBuyersearch);
    }
    async deleteById(id) {
        await this.logBuyersearchRepository.deleteById(id);
    }
};
exports.LogBuyersearchController = LogBuyersearchController;
tslib_1.__decorate([
    (0, rest_1.post)('/log-buyersearches'),
    (0, rest_1.response)(200, {
        description: 'LogBuyersearch model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.LogBuyersearch) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.LogBuyersearch, {
                    title: 'NewLogBuyersearch',
                    exclude: ['logBuyersearchId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], LogBuyersearchController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/log-buyersearches/count'),
    (0, rest_1.response)(200, {
        description: 'LogBuyersearch model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.LogBuyersearch)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], LogBuyersearchController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/log-buyersearches'),
    (0, rest_1.response)(200, {
        description: 'Array of LogBuyersearch model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.LogBuyersearch, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.LogBuyersearch)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], LogBuyersearchController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/log-buyersearches'),
    (0, rest_1.response)(200, {
        description: 'LogBuyersearch PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.LogBuyersearch, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.LogBuyersearch)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.LogBuyersearch, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], LogBuyersearchController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/log-buyersearches/{id}'),
    (0, rest_1.response)(200, {
        description: 'LogBuyersearch model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.LogBuyersearch, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.LogBuyersearch, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], LogBuyersearchController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/log-buyersearches/{id}'),
    (0, rest_1.response)(204, {
        description: 'LogBuyersearch PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.LogBuyersearch, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.LogBuyersearch]),
    tslib_1.__metadata("design:returntype", Promise)
], LogBuyersearchController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/log-buyersearches/{id}'),
    (0, rest_1.response)(204, {
        description: 'LogBuyersearch PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.LogBuyersearch]),
    tslib_1.__metadata("design:returntype", Promise)
], LogBuyersearchController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/log-buyersearches/{id}'),
    (0, rest_1.response)(204, {
        description: 'LogBuyersearch DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], LogBuyersearchController.prototype, "deleteById", null);
exports.LogBuyersearchController = LogBuyersearchController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.LogBuyersearchRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.LogBuyersearchRepository])
], LogBuyersearchController);
//# sourceMappingURL=log-buyersearch.controller.js.map