import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { LogBuyer } from '../models';
import { LogBuyerRepository } from '../repositories';
export declare class LogBuyerController {
    logBuyerRepository: LogBuyerRepository;
    constructor(logBuyerRepository: LogBuyerRepository);
    create(logBuyer: Omit<LogBuyer, 'logBuyerId'>): Promise<LogBuyer>;
    count(where?: Where<LogBuyer>): Promise<Count>;
    find(filter?: Filter<LogBuyer>): Promise<any[]>;
    updateAll(logBuyer: LogBuyer, where?: Where<LogBuyer>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<LogBuyer>): Promise<any>;
    updateById(id: number, logBuyer: LogBuyer): Promise<void>;
    replaceById(id: number, logBuyer: LogBuyer): Promise<void>;
    deleteById(id: number): Promise<void>;
}
