import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { GenderMaster } from '../models';
import { GenderMasterRepository } from '../repositories';
export declare class GenderMasterController {
    genderMasterRepository: GenderMasterRepository;
    constructor(genderMasterRepository: GenderMasterRepository);
    create(genderMaster: Omit<GenderMaster, 'genderId'>): Promise<GenderMaster>;
    count(where?: Where<GenderMaster>): Promise<Count>;
    find(filter?: Filter<GenderMaster>): Promise<GenderMaster[]>;
    updateAll(genderMaster: GenderMaster, where?: Where<GenderMaster>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<GenderMaster>): Promise<GenderMaster>;
    updateById(id: number, genderMaster: GenderMaster): Promise<void>;
    replaceById(id: number, genderMaster: GenderMaster): Promise<void>;
    deleteById(id: number): Promise<void>;
}
