"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FloormasterController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let FloormasterController = class FloormasterController {
    constructor(floorMasterRepository) {
        this.floorMasterRepository = floorMasterRepository;
    }
    async create(floorMaster) {
        return this.floorMasterRepository.create(floorMaster);
    }
    async count(where) {
        return this.floorMasterRepository.count(where);
    }
    async find(filter) {
        return this.floorMasterRepository.find(filter);
    }
    async updateAll(floorMaster, where) {
        return this.floorMasterRepository.updateAll(floorMaster, where);
    }
    async findById(id, filter) {
        return this.floorMasterRepository.findById(id, filter);
    }
    async updateById(id, floorMaster) {
        await this.floorMasterRepository.updateById(id, floorMaster);
    }
    async replaceById(id, floorMaster) {
        await this.floorMasterRepository.replaceById(id, floorMaster);
    }
    async deleteById(id) {
        await this.floorMasterRepository.deleteById(id);
    }
};
exports.FloormasterController = FloormasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/floor-masters'),
    (0, rest_1.response)(200, {
        description: 'FloorMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.FloorMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.FloorMaster, {
                    title: 'NewFloorMaster',
                    exclude: ['floorId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], FloormasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/floor-masters/count'),
    (0, rest_1.response)(200, {
        description: 'FloorMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.FloorMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], FloormasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/floor-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of FloorMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.FloorMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.FloorMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], FloormasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/floor-masters'),
    (0, rest_1.response)(200, {
        description: 'FloorMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.FloorMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.FloorMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.FloorMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], FloormasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/floor-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'FloorMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.FloorMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.FloorMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], FloormasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/floor-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'FloorMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.FloorMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.FloorMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], FloormasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/floor-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'FloorMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.FloorMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], FloormasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/floor-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'FloorMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], FloormasterController.prototype, "deleteById", null);
exports.FloormasterController = FloormasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.FloorMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.FloorMasterRepository])
], FloormasterController);
//# sourceMappingURL=floormaster.controller.js.map