"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExclusivepropertyController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let ExclusivepropertyController = class ExclusivepropertyController {
    constructor(exclusivePropertyMasterRepository) {
        this.exclusivePropertyMasterRepository = exclusivePropertyMasterRepository;
    }
    async create(exclusivePropertyMaster) {
        return this.exclusivePropertyMasterRepository.create(exclusivePropertyMaster);
    }
    async count(where) {
        return this.exclusivePropertyMasterRepository.count(where);
    }
    async find(filter) {
        return this.exclusivePropertyMasterRepository.find(filter);
    }
    async updateAll(exclusivePropertyMaster, where) {
        return this.exclusivePropertyMasterRepository.updateAll(exclusivePropertyMaster, where);
    }
    async findById(id, filter) {
        return this.exclusivePropertyMasterRepository.findById(id, filter);
    }
    async updateById(id, exclusivePropertyMaster) {
        await this.exclusivePropertyMasterRepository.updateById(id, exclusivePropertyMaster);
    }
    async replaceById(id, exclusivePropertyMaster) {
        await this.exclusivePropertyMasterRepository.replaceById(id, exclusivePropertyMaster);
    }
    async deleteById(id) {
        await this.exclusivePropertyMasterRepository.deleteById(id);
    }
};
exports.ExclusivepropertyController = ExclusivepropertyController;
tslib_1.__decorate([
    (0, rest_1.post)('/exclusive-property-masters'),
    (0, rest_1.response)(200, {
        description: 'ExclusivePropertyMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.ExclusivePropertyMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.ExclusivePropertyMaster, {
                    title: 'NewExclusivePropertyMaster',
                    exclude: ['exclusivePropertyId	'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], ExclusivepropertyController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/exclusive-property-masters/count'),
    (0, rest_1.response)(200, {
        description: 'ExclusivePropertyMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.ExclusivePropertyMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], ExclusivepropertyController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/exclusive-property-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of ExclusivePropertyMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.ExclusivePropertyMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.ExclusivePropertyMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], ExclusivepropertyController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/exclusive-property-masters'),
    (0, rest_1.response)(200, {
        description: 'ExclusivePropertyMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.ExclusivePropertyMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.ExclusivePropertyMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.ExclusivePropertyMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], ExclusivepropertyController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/exclusive-property-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'ExclusivePropertyMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.ExclusivePropertyMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.ExclusivePropertyMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], ExclusivepropertyController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/exclusive-property-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'ExclusivePropertyMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.ExclusivePropertyMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.ExclusivePropertyMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], ExclusivepropertyController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/exclusive-property-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'ExclusivePropertyMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.ExclusivePropertyMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], ExclusivepropertyController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/exclusive-property-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'ExclusivePropertyMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], ExclusivepropertyController.prototype, "deleteById", null);
exports.ExclusivepropertyController = ExclusivepropertyController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.ExclusivePropertyMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.ExclusivePropertyMasterRepository])
], ExclusivepropertyController);
//# sourceMappingURL=exclusiveproperty.controller.js.map