"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DurationmasterController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let DurationmasterController = class DurationmasterController {
    constructor(durationMasterRepository) {
        this.durationMasterRepository = durationMasterRepository;
    }
    async create(durationMaster) {
        return this.durationMasterRepository.create(durationMaster);
    }
    async count(where) {
        return this.durationMasterRepository.count(where);
    }
    async find(filter) {
        return this.durationMasterRepository.find(filter);
    }
    async updateAll(durationMaster, where) {
        return this.durationMasterRepository.updateAll(durationMaster, where);
    }
    async findById(id, filter) {
        return this.durationMasterRepository.findById(id, filter);
    }
    async updateById(id, durationMaster) {
        await this.durationMasterRepository.updateById(id, durationMaster);
    }
    async replaceById(id, durationMaster) {
        await this.durationMasterRepository.replaceById(id, durationMaster);
    }
    async deleteById(id) {
        await this.durationMasterRepository.deleteById(id);
    }
};
exports.DurationmasterController = DurationmasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/duration-masters'),
    (0, rest_1.response)(200, {
        description: 'DurationMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.DurationMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.DurationMaster, {
                    title: 'NewDurationMaster',
                    exclude: ['durationId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], DurationmasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/duration-masters/count'),
    (0, rest_1.response)(200, {
        description: 'DurationMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.DurationMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], DurationmasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/duration-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of DurationMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.DurationMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.DurationMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], DurationmasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/duration-masters'),
    (0, rest_1.response)(200, {
        description: 'DurationMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.DurationMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.DurationMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.DurationMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], DurationmasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/duration-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'DurationMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.DurationMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.DurationMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], DurationmasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/duration-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'DurationMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.DurationMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.DurationMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], DurationmasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/duration-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'DurationMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.DurationMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], DurationmasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/duration-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'DurationMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], DurationmasterController.prototype, "deleteById", null);
exports.DurationmasterController = DurationmasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.DurationMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.DurationMasterRepository])
], DurationmasterController);
//# sourceMappingURL=durationmaster.controller.js.map