import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { DurationMaster } from '../models';
import { DurationMasterRepository } from '../repositories';
export declare class DurationmasterController {
    durationMasterRepository: DurationMasterRepository;
    constructor(durationMasterRepository: DurationMasterRepository);
    create(durationMaster: Omit<DurationMaster, 'durationId'>): Promise<DurationMaster>;
    count(where?: Where<DurationMaster>): Promise<Count>;
    find(filter?: Filter<DurationMaster>): Promise<DurationMaster[]>;
    updateAll(durationMaster: DurationMaster, where?: Where<DurationMaster>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<DurationMaster>): Promise<DurationMaster>;
    updateById(id: number, durationMaster: DurationMaster): Promise<void>;
    replaceById(id: number, durationMaster: DurationMaster): Promise<void>;
    deleteById(id: number): Promise<void>;
}
