"use strict";
// import {
//   Count,
//   CountSchema,
//   Filter,
//   FilterExcludingWhere,
//   repository,
//   Where,
// } from '@loopback/repository';
// import {
//   post,
//   param,
//   get,
//   getModelSchemaRef,
//   patch,
//   put,
//   del,
//   requestBody,
//   response,
// } from '@loopback/rest';
// import {CityMaster} from '../models';
// import {CityMasterRepository} from '../repositories';
Object.defineProperty(exports, "__esModule", { value: true });
exports.CityMasterController = void 0;
const tslib_1 = require("tslib");
// export class CityMasterController {
//   constructor(
//     @repository(CityMasterRepository)
//     public cityMasterRepository : CityMasterRepository,
//   ) {}
//   @post('/city-masters')
//   @response(200, {
//     description: 'CityMaster model instance',
//     content: {'application/json': {schema: getModelSchemaRef(CityMaster)}},
//   })
//   async create(
//     @requestBody({
//       content: {
//         'application/json': {
//           schema: getModelSchemaRef(CityMaster, {
//             title: 'NewCityMaster',
//             exclude: ['cityId'],
//           }),
//         },
//       },
//     })
//     cityMaster: Omit<CityMaster, 'cityId'>,
//   ): Promise<CityMaster> {
//     return this.cityMasterRepository.create(cityMaster);
//   }
//   @get('/city-masters/count')
//   @response(200, {
//     description: 'CityMaster model count',
//     content: {'application/json': {schema: CountSchema}},
//   })
//   async count(
//     @param.where(CityMaster) where?: Where<CityMaster>,
//   ): Promise<Count> {
//     return this.cityMasterRepository.count(where);
//   }
//   @get('/city-masters')
//   @response(200, {
//     description: 'Array of CityMaster model instances',
//     content: {
//       'application/json': {
//         schema: {
//           type: 'array',
//           items: getModelSchemaRef(CityMaster, {includeRelations: true}),
//         },
//       },
//     },
//   })
//   async find(
//     @param.filter(CityMaster) filter?: Filter<CityMaster>,
//   ): Promise<CityMaster[]> {
//     return this.cityMasterRepository.find(filter);
//   }
//   @patch('/city-masters')
//   @response(200, {
//     description: 'CityMaster PATCH success count',
//     content: {'application/json': {schema: CountSchema}},
//   })
//   async updateAll(
//     @requestBody({
//       content: {
//         'application/json': {
//           schema: getModelSchemaRef(CityMaster, {partial: true}),
//         },
//       },
//     })
//     cityMaster: CityMaster,
//     @param.where(CityMaster) where?: Where<CityMaster>,
//   ): Promise<Count> {
//     return this.cityMasterRepository.updateAll(cityMaster, where);
//   }
//   @get('/city-masters/{id}')
//   @response(200, {
//     description: 'CityMaster model instance',
//     content: {
//       'application/json': {
//         schema: getModelSchemaRef(CityMaster, {includeRelations: true}),
//       },
//     },
//   })
//   async findById(
//     @param.path.number('id') id: number,
//     @param.filter(CityMaster, {exclude: 'where'}) filter?: FilterExcludingWhere<CityMaster>
//   ): Promise<CityMaster> {
//     return this.cityMasterRepository.findById(id, filter);
//   }
//   @patch('/city-masters/{id}')
//   @response(204, {
//     description: 'CityMaster PATCH success',
//   })
//   async updateById(
//     @param.path.number('id') id: number,
//     @requestBody({
//       content: {
//         'application/json': {
//           schema: getModelSchemaRef(CityMaster, {partial: true}),
//         },
//       },
//     })
//     cityMaster: CityMaster,
//   ): Promise<void> {
//     await this.cityMasterRepository.updateById(id, cityMaster);
//   }
//   @put('/city-masters/{id}')
//   @response(204, {
//     description: 'CityMaster PUT success',
//   })
//   async replaceById(
//     @param.path.number('id') id: number,
//     @requestBody() cityMaster: CityMaster,
//   ): Promise<void> {
//     await this.cityMasterRepository.replaceById(id, cityMaster);
//   }
//   @del('/city-masters/{id}')
//   @response(204, {
//     description: 'CityMaster DELETE success',
//   })
//   async deleteById(@param.path.number('id') id: number): Promise<void> {
//     await this.cityMasterRepository.deleteById(id);
//   }
// }
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let CityMasterController = class CityMasterController {
    constructor(cityMasterRepository) {
        this.cityMasterRepository = cityMasterRepository;
    }
    async create(cityMaster) {
        return this.cityMasterRepository.create(cityMaster);
    }
    async count(where) {
        return this.cityMasterRepository.count(where);
    }
    async find(filter) {
        return this.cityMasterRepository.find(filter);
    }
    async updateAll(cityMaster, where) {
        return this.cityMasterRepository.updateAll(cityMaster, where);
    }
    async findById(id, filter) {
        return this.cityMasterRepository.findById(id, filter);
    }
    async updateById(id, cityMaster) {
        await this.cityMasterRepository.updateById(id, cityMaster);
    }
    async replaceById(id, cityMaster) {
        await this.cityMasterRepository.replaceById(id, cityMaster);
    }
    async deleteById(id) {
        await this.cityMasterRepository.deleteById(id);
    }
};
exports.CityMasterController = CityMasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/city-masters'),
    (0, rest_1.response)(200, {
        description: 'CityMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.CityMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.CityMaster, {
                    title: 'NewCityMaster',
                    exclude: ['cityId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], CityMasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/city-masters/count'),
    (0, rest_1.response)(200, {
        description: 'CityMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.CityMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], CityMasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/city-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of CityMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.CityMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.CityMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], CityMasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/city-masters'),
    (0, rest_1.response)(200, {
        description: 'CityMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.CityMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.CityMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.CityMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], CityMasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/city-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'CityMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.CityMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.CityMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], CityMasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/city-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'CityMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.CityMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.CityMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], CityMasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/city-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'CityMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.CityMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], CityMasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/city-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'CityMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], CityMasterController.prototype, "deleteById", null);
exports.CityMasterController = CityMasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.CityMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.CityMasterRepository])
], CityMasterController);
//# sourceMappingURL=city-master.controller.js.map