"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackgroundimagemasterController = void 0;
const tslib_1 = require("tslib");
/* eslint-disable @typescript-eslint/no-shadow */
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const core_1 = require("@loopback/core");
const fs_1 = tslib_1.__importDefault(require("fs"));
const multer_1 = tslib_1.__importDefault(require("multer"));
const path_1 = tslib_1.__importDefault(require("path"));
const models_1 = require("../models");
const repositories_1 = require("../repositories");
// Upload directory path
const uploadDir = path_1.default.resolve(__dirname, '../../uploads/Slider-Photo');
fs_1.default.mkdirSync(uploadDir, { recursive: true });
// Multer storage config
const storage = multer_1.default.diskStorage({
    destination(req, file, cb) {
        cb(null, uploadDir);
    },
    filename(req, file, cb) {
        const uniqueName = `${Date.now()}-${Math.round(Math.random() * 1e9)}${path_1.default.extname(file.originalname)}`;
        cb(null, uniqueName);
    },
});
const upload = (0, multer_1.default)({ storage });
let BackgroundimagemasterController = class BackgroundimagemasterController {
    constructor(request, backgroundImageMasterRepository) {
        this.request = request;
        this.backgroundImageMasterRepository = backgroundImageMasterRepository;
    }
    // CREATE with file upload
    async create() {
        const req = this.request;
        const uploaded = await new Promise((resolve, reject) => {
            upload.single('backImage')(req, {}, (err) => {
                if (err)
                    return reject(err);
                resolve(req.file ? [req.file] : []);
            });
        });
        const file = uploaded[0];
        const body = req.body;
        const newData = {
            ...body,
            backImage: file ? file.filename : '',
        };
        return this.backgroundImageMasterRepository.create(newData);
    }
    // COUNT
    async count(where) {
        return this.backgroundImageMasterRepository.count(where);
    }
    // FIND
    async find(filter) {
        return this.backgroundImageMasterRepository.find(filter);
    }
    // FIND BY ID
    async findById(id, filter) {
        return this.backgroundImageMasterRepository.findById(id, filter);
    }
    // PATCH by id with file upload
    async updateById(id) {
        const req = this.request;
        const uploaded = await new Promise((resolve, reject) => {
            upload.single('backImage')(req, {}, (err) => {
                if (err)
                    return reject(err);
                resolve(req.file ? [req.file] : []);
            });
        });
        const file = uploaded[0];
        const body = req.body;
        const updatedBackground = {
            ...body,
            ...(file ? { backImage: file.filename } : {}),
        };
        await this.backgroundImageMasterRepository.updateById(id, updatedBackground);
    }
    // PUT by id (replace) with file upload
    async replaceById(id) {
        const req = this.request;
        const uploaded = await new Promise((resolve, reject) => {
            upload.single('backImage')(req, {}, (err) => {
                if (err)
                    return reject(err);
                resolve(req.file ? [req.file] : []);
            });
        });
        const file = uploaded[0];
        const body = req.body;
        const replacedBackground = {
            ...body,
            backImage: file ? file.filename : '',
        };
        await this.backgroundImageMasterRepository.replaceById(id, replacedBackground);
    }
    // PATCH multiple records
    async updateAll(backgroundImageMaster, where) {
        return this.backgroundImageMasterRepository.updateAll(backgroundImageMaster, where);
    }
    // DELETE by id
    async deleteById(id) {
        await this.backgroundImageMasterRepository.deleteById(id);
    }
};
exports.BackgroundimagemasterController = BackgroundimagemasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/background-image-masters'),
    (0, rest_1.response)(200, {
        description: 'BackgroundImageMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.BackgroundImageMaster) } },
    }),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", Promise)
], BackgroundimagemasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/background-image-masters/count'),
    (0, rest_1.response)(200, {
        description: 'BackgroundImageMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.BackgroundImageMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], BackgroundimagemasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/background-image-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of BackgroundImageMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.BackgroundImageMaster, {
                        includeRelations: true,
                    }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.BackgroundImageMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], BackgroundimagemasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.get)('/background-image-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'BackgroundImageMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.BackgroundImageMaster, {
                    includeRelations: true,
                }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.BackgroundImageMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], BackgroundimagemasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/background-image-masters/{id}'),
    (0, rest_1.response)(204, { description: 'BackgroundImageMaster PATCH success' }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], BackgroundimagemasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/background-image-masters/{id}'),
    (0, rest_1.response)(204, { description: 'BackgroundImageMaster PUT success' }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], BackgroundimagemasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/background-image-masters'),
    (0, rest_1.response)(200, {
        description: 'BackgroundImageMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        description: 'multipart/form-data request',
        required: true,
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.BackgroundImageMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.BackgroundImageMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.BackgroundImageMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], BackgroundimagemasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.del)('/background-image-masters/{id}'),
    (0, rest_1.response)(204, { description: 'BackgroundImageMaster DELETE success' }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], BackgroundimagemasterController.prototype, "deleteById", null);
exports.BackgroundimagemasterController = BackgroundimagemasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, core_1.inject)(rest_1.RestBindings.Http.REQUEST)),
    tslib_1.__param(1, (0, repository_1.repository)(repositories_1.BackgroundImageMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [Object, repositories_1.BackgroundImageMasterRepository])
], BackgroundimagemasterController);
//# sourceMappingURL=backgroundimagemaster.controller.js.map