/// <reference types="express" />
import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { Request } from '@loopback/rest';
import { BackgroundImageMaster } from '../models';
import { BackgroundImageMasterRepository } from '../repositories';
export declare class BackgroundimagemasterController {
    private request;
    backgroundImageMasterRepository: BackgroundImageMasterRepository;
    constructor(request: Request, backgroundImageMasterRepository: BackgroundImageMasterRepository);
    create(): Promise<BackgroundImageMaster>;
    count(where?: Where<BackgroundImageMaster>): Promise<Count>;
    find(filter?: Filter<BackgroundImageMaster>): Promise<BackgroundImageMaster[]>;
    findById(id: number, filter?: FilterExcludingWhere<BackgroundImageMaster>): Promise<BackgroundImageMaster>;
    updateById(id: number): Promise<void>;
    replaceById(id: number): Promise<void>;
    updateAll(backgroundImageMaster: BackgroundImageMaster, where?: Where<BackgroundImageMaster>): Promise<Count>;
    deleteById(id: number): Promise<void>;
}
