"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AmenitiesMasterController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let AmenitiesMasterController = class AmenitiesMasterController {
    constructor(amenitiesMasterRepository) {
        this.amenitiesMasterRepository = amenitiesMasterRepository;
    }
    async create(amenitiesMaster) {
        return this.amenitiesMasterRepository.create(amenitiesMaster);
    }
    async count(where) {
        return this.amenitiesMasterRepository.count(where);
    }
    async find(filter) {
        return this.amenitiesMasterRepository.find(filter);
    }
    async updateAll(amenitiesMaster, where) {
        return this.amenitiesMasterRepository.updateAll(amenitiesMaster, where);
    }
    async findById(id, filter) {
        return this.amenitiesMasterRepository.findById(id, filter);
    }
    async updateById(id, amenitiesMaster) {
        await this.amenitiesMasterRepository.updateById(id, amenitiesMaster);
    }
    async replaceById(id, amenitiesMaster) {
        await this.amenitiesMasterRepository.replaceById(id, amenitiesMaster);
    }
    async deleteById(id) {
        await this.amenitiesMasterRepository.deleteById(id);
    }
};
exports.AmenitiesMasterController = AmenitiesMasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/amenities-masters'),
    (0, rest_1.response)(200, {
        description: 'AmenitiesMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.AmenitiesMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.AmenitiesMaster, {
                    title: 'NewAmenitiesMaster',
                    exclude: ['amenitiesId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], AmenitiesMasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/amenities-masters/count'),
    (0, rest_1.response)(200, {
        description: 'AmenitiesMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.AmenitiesMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], AmenitiesMasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/amenities-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of AmenitiesMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.AmenitiesMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.AmenitiesMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], AmenitiesMasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/amenities-masters'),
    (0, rest_1.response)(200, {
        description: 'AmenitiesMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.AmenitiesMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.AmenitiesMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.AmenitiesMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], AmenitiesMasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/amenities-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'AmenitiesMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.AmenitiesMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.AmenitiesMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], AmenitiesMasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/amenities-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'AmenitiesMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.AmenitiesMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.AmenitiesMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], AmenitiesMasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/amenities-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'AmenitiesMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.AmenitiesMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], AmenitiesMasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/amenities-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'AmenitiesMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], AmenitiesMasterController.prototype, "deleteById", null);
exports.AmenitiesMasterController = AmenitiesMasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.AmenitiesMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.AmenitiesMasterRepository])
], AmenitiesMasterController);
//# sourceMappingURL=amenities-master.controller.js.map