import { Count, Filter, FilterExcludingWhere, Where } from '@loopback/repository';
import { AmenitiesMaster } from '../models';
import { AmenitiesMasterRepository } from '../repositories';
export declare class AmenitiesMasterController {
    amenitiesMasterRepository: AmenitiesMasterRepository;
    constructor(amenitiesMasterRepository: AmenitiesMasterRepository);
    create(amenitiesMaster: Omit<AmenitiesMaster, 'amenitiesId'>): Promise<AmenitiesMaster>;
    count(where?: Where<AmenitiesMaster>): Promise<Count>;
    find(filter?: Filter<AmenitiesMaster>): Promise<AmenitiesMaster[]>;
    updateAll(amenitiesMaster: AmenitiesMaster, where?: Where<AmenitiesMaster>): Promise<Count>;
    findById(id: number, filter?: FilterExcludingWhere<AmenitiesMaster>): Promise<AmenitiesMaster>;
    updateById(id: number, amenitiesMaster: AmenitiesMaster): Promise<void>;
    replaceById(id: number, amenitiesMaster: AmenitiesMaster): Promise<void>;
    deleteById(id: number): Promise<void>;
}
