"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdsTypeMasterController = void 0;
const tslib_1 = require("tslib");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const models_1 = require("../models");
const repositories_1 = require("../repositories");
let AdsTypeMasterController = class AdsTypeMasterController {
    constructor(adsTypeMasterRepository) {
        this.adsTypeMasterRepository = adsTypeMasterRepository;
    }
    async create(adsTypeMaster) {
        return this.adsTypeMasterRepository.create(adsTypeMaster);
    }
    async count(where) {
        return this.adsTypeMasterRepository.count(where);
    }
    async find(filter) {
        return this.adsTypeMasterRepository.find(filter);
    }
    async updateAll(adsTypeMaster, where) {
        return this.adsTypeMasterRepository.updateAll(adsTypeMaster, where);
    }
    async findById(id, filter) {
        return this.adsTypeMasterRepository.findById(id, filter);
    }
    async updateById(id, adsTypeMaster) {
        await this.adsTypeMasterRepository.updateById(id, adsTypeMaster);
    }
    async replaceById(id, adsTypeMaster) {
        await this.adsTypeMasterRepository.replaceById(id, adsTypeMaster);
    }
    async deleteById(id) {
        await this.adsTypeMasterRepository.deleteById(id);
    }
};
exports.AdsTypeMasterController = AdsTypeMasterController;
tslib_1.__decorate([
    (0, rest_1.post)('/ads-type-masters'),
    (0, rest_1.response)(200, {
        description: 'AdsTypeMaster model instance',
        content: { 'application/json': { schema: (0, rest_1.getModelSchemaRef)(models_1.AdsTypeMaster) } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.AdsTypeMaster, {
                    title: 'NewAdsTypeMaster',
                    exclude: ['adsTypeId'],
                }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], AdsTypeMasterController.prototype, "create", null);
tslib_1.__decorate([
    (0, rest_1.get)('/ads-type-masters/count'),
    (0, rest_1.response)(200, {
        description: 'AdsTypeMaster model count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, rest_1.param.where(models_1.AdsTypeMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], AdsTypeMasterController.prototype, "count", null);
tslib_1.__decorate([
    (0, rest_1.get)('/ads-type-masters'),
    (0, rest_1.response)(200, {
        description: 'Array of AdsTypeMaster model instances',
        content: {
            'application/json': {
                schema: {
                    type: 'array',
                    items: (0, rest_1.getModelSchemaRef)(models_1.AdsTypeMaster, { includeRelations: true }),
                },
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.filter(models_1.AdsTypeMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Object]),
    tslib_1.__metadata("design:returntype", Promise)
], AdsTypeMasterController.prototype, "find", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/ads-type-masters'),
    (0, rest_1.response)(200, {
        description: 'AdsTypeMaster PATCH success count',
        content: { 'application/json': { schema: repository_1.CountSchema } },
    }),
    tslib_1.__param(0, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.AdsTypeMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__param(1, rest_1.param.where(models_1.AdsTypeMaster)),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [models_1.AdsTypeMaster, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], AdsTypeMasterController.prototype, "updateAll", null);
tslib_1.__decorate([
    (0, rest_1.get)('/ads-type-masters/{id}'),
    (0, rest_1.response)(200, {
        description: 'AdsTypeMaster model instance',
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.AdsTypeMaster, { includeRelations: true }),
            },
        },
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, rest_1.param.filter(models_1.AdsTypeMaster, { exclude: 'where' })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Object]),
    tslib_1.__metadata("design:returntype", Promise)
], AdsTypeMasterController.prototype, "findById", null);
tslib_1.__decorate([
    (0, rest_1.patch)('/ads-type-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'AdsTypeMaster PATCH success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)({
        content: {
            'application/json': {
                schema: (0, rest_1.getModelSchemaRef)(models_1.AdsTypeMaster, { partial: true }),
            },
        },
    })),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.AdsTypeMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], AdsTypeMasterController.prototype, "updateById", null);
tslib_1.__decorate([
    (0, rest_1.put)('/ads-type-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'AdsTypeMaster PUT success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__param(1, (0, rest_1.requestBody)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, models_1.AdsTypeMaster]),
    tslib_1.__metadata("design:returntype", Promise)
], AdsTypeMasterController.prototype, "replaceById", null);
tslib_1.__decorate([
    (0, rest_1.del)('/ads-type-masters/{id}'),
    (0, rest_1.response)(204, {
        description: 'AdsTypeMaster DELETE success',
    }),
    tslib_1.__param(0, rest_1.param.path.number('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number]),
    tslib_1.__metadata("design:returntype", Promise)
], AdsTypeMasterController.prototype, "deleteById", null);
exports.AdsTypeMasterController = AdsTypeMasterController = tslib_1.__decorate([
    tslib_1.__param(0, (0, repository_1.repository)(repositories_1.AdsTypeMasterRepository)),
    tslib_1.__metadata("design:paramtypes", [repositories_1.AdsTypeMasterRepository])
], AdsTypeMasterController);
//# sourceMappingURL=ads-type-master.controller.js.map