"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LelloBackendApplication = void 0;
const tslib_1 = require("tslib");
const boot_1 = require("@loopback/boot");
const rest_explorer_1 = require("@loopback/rest-explorer");
const repository_1 = require("@loopback/repository");
const rest_1 = require("@loopback/rest");
const service_proxy_1 = require("@loopback/service-proxy");
const path_1 = tslib_1.__importDefault(require("path"));
const sequence_1 = require("./sequence");
const repositories_1 = require("./repositories");
const models_1 = require("./models");
class LelloBackendApplication extends (0, boot_1.BootMixin)((0, service_proxy_1.ServiceMixin)((0, repository_1.RepositoryMixin)(rest_1.RestApplication))) {
    constructor(options = {}) {
        super(options);
        this.model(models_1.PostPropertyAmenities);
        this.repository(repositories_1.PostPropertyAmenitiesRepository);
        this.static('/uploads/seller-profiles', path_1.default.join(__dirname, '../uploads/seller-profiles'));
        this.static('/uploads/Slider-Photo', path_1.default.join(__dirname, '../uploads/Slider-Photo'));
        this.static('/uploads/property-images', path_1.default.join(__dirname, '../uploads/property-images'));
        this.static('/uploads/testimonial-images', path_1.default.join(__dirname, '../uploads/testimonial-images'));
        this.static('/uploads/real-estate-images', path_1.default.join(__dirname, '../uploads/real-estate-images'));
        this.static('/uploads/ads', path_1.default.join(__dirname, '../uploads/ads'));
        this.static('/uploads/packages', path_1.default.join(__dirname, '../uploads/packages'));
        this.projectRoot = __dirname;
        // Customize @loopback/boot Booter Conventions here
        this.bootOptions = {
            controllers: {
                // Customize ControllerBooter Conventions here
                dirs: ['controllers'],
                extensions: ['.controller.js'],
                nested: true,
            },
        };
        // Set up the custom sequence
        this.sequence(sequence_1.MySequence);
        // Set up default home page
        this.static('/', path_1.default.join(__dirname, '../public'));
        // Customize @loopback/rest-explorer configuration here
        this.configure(rest_explorer_1.RestExplorerBindings.COMPONENT).to({
            path: '/explorer',
        });
        this.component(rest_explorer_1.RestExplorerComponent);
        this.projectRoot = __dirname;
        // Customize @loopback/boot Booter Conventions here
        this.bootOptions = {
            controllers: {
                // Customize ControllerBooter Conventions here
                dirs: ['controllers'],
                extensions: ['.controller.js'],
                nested: true,
            },
        };
    }
}
exports.LelloBackendApplication = LelloBackendApplication;
//# sourceMappingURL=application.js.map